/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleAdapter;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class ElementStringAdapter
extends SimpleAdapter<String> {
    public String adapt(ReadGraph g, Resource r) throws ValidationException, ServiceException {
        try {
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
            Resource name = r;
            Resource component = g.getPossibleObject(r, mr.ElementToComponent);
            if (component != null) {
                name = component;
            }
            StringBuilder sb = new StringBuilder();
            Layer0 b = Layer0.getInstance((ReadGraph)g);
            String nameName = (String)g.getPossibleRelatedValue(name, b.HasName);
            if (nameName != null) {
                sb.append(nameName);
            }
            boolean first = true;
            for (Resource rType : g.getPrincipalTypes(r)) {
                String s = (String)g.adapt(rType, String.class);
                if (first) {
                    sb.append(" : ");
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(s);
            }
            return sb.toString();
        }
        catch (AdaptionException e) {
            throw new ValidationException((Throwable)e);
        }
    }
}

