/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class ElementRemover
extends AbstractRemover {
    private static final boolean DEBUG = false;

    public ElementRemover(Resource element) {
        super(element);
    }

    public void remove(WriteGraph graph) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(this.resource, STR.Connection)) {
            this.removeConnection(graph);
        } else {
            this.removeElement(graph);
        }
    }

    public void removeElement(WriteGraph graph) throws DatabaseException {
        Set connectors = null;
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Collection connectedTo = graph.getObjects(this.resource, STR.IsConnectedTo);
        for (Resource connector : connectedTo) {
            if (connectors == null) {
                connectors = new THashSet(connectedTo.size());
            }
            connectors.add(connector);
        }
        Collection monitors = graph.getObjects(this.resource, DIA.HasMonitorComponent_Inverse);
        for (Resource diagram : OrderedSetElementsPredicate.INSTANCE.getSubjects((ReadGraph)graph, this.resource)) {
            OrderedSetUtils.remove((WriteGraph)graph, (Resource)diagram, (Resource)this.resource);
        }
        EntityRemover.remove((WriteGraph)graph, (Resource)this.resource);
        ConnectionUtil cu = null;
        Set connectionsToRemove = null;
        if (connectors != null) {
            cu = new ConnectionUtil(graph);
            THashSet touchedConnections = new THashSet(connectors.size());
            for (Resource connector : connectors) {
                Resource connection = ConnectionUtil.tryGetConnection((ReadGraph)graph, (Resource)connector);
                if (connection != null) {
                    touchedConnections.add(connection);
                }
                cu.removeConnectionPart(connector);
            }
            for (Resource connection : touchedConnections) {
                int removedInteriorRouteNodes;
                int removedConnectors = cu.removeUnusedConnectors(connection);
                while ((removedInteriorRouteNodes = cu.removeExtraInteriorRouteNodes(connection)) != 0) {
                }
                int connectorCount = cu.getConnectedConnectors(connection, null).size();
                if (connectorCount >= 2) continue;
                if (connectionsToRemove == null) {
                    connectionsToRemove = new THashSet(touchedConnections.size());
                }
                connectionsToRemove.add(connection);
            }
        }
        if (connectionsToRemove != null) {
            for (Resource connection : connectionsToRemove) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)connection);
            }
        }
        if (!monitors.isEmpty()) {
            for (Resource monitor : monitors) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)monitor);
            }
        }
    }

    public void removeConnection(WriteGraph graph) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList<Resource> objects = new ArrayList<Resource>();
        Resource[] resourceArray = new Resource[]{DIA.HasMonitorComponent_Inverse, MOD.ElementToComponent, MOD.DiagramConnectionToConnection, MOD.DiagramConnectionToConnectionSpecial};
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource relation = resourceArray[n2];
            for (Resource object : graph.getObjects(this.resource, relation)) {
                if (object.equals(this.resource)) continue;
                objects.add(object);
            }
            ++n2;
        }
        new ConnectionUtil(graph).removeConnection(this.resource);
        if (!objects.isEmpty()) {
            for (Resource object : objects) {
                RemoverUtil.remove((WriteGraph)graph, (Resource)object);
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + String.valueOf(this.resource);
    }
}

