/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLDropAction
implements DropActionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLDropAction.class);
    private final Resource rule;

    public SCLDropAction(ReadGraph graph, Resource rule) throws DatabaseException {
        this.rule = rule;
    }

    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        return new SCLDropActionRunnable(this.rule, (Resource)target, source, operation);
    }

    static class RuleFunctionRequest
    extends ResourceRead<Function3<Resource, Object, Integer, Object>> {
        protected RuleFunctionRequest(Resource rule) {
            super(rule);
        }

        public Function3<Resource, Object, Integer, Object> perform(ReadGraph graph) throws DatabaseException {
            Variable ruleVariable = Variables.getVariable((ReadGraph)graph, (Resource)this.resource);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            return (Function3)ruleVariable.getPossiblePropertyValue(graph, MOD.SCLDropAction_action);
        }
    }

    public static class SCLDropActionRunnable
    implements Runnable {
        public Resource rule;
        public Resource target;
        public Object source;
        public int operation;

        public SCLDropActionRunnable(Resource rule, Resource target, Object source, int operation) {
            this.rule = rule;
            this.target = target;
            this.source = source;
            this.operation = operation;
        }

        @Override
        public void run() {
            Simantics.getSession().markUndoPoint();
            try {
                Function3 function = (Function3)Simantics.getSession().syncRequest((Read)new RuleFunctionRequest(this.rule));
                function.apply((Object)this.target, this.source, (Object)this.operation);
            }
            catch (DatabaseException e) {
                LOGGER.error("SCLDropActionRunnable failed to request/apply RuleFunction {}", (Object)this.rule, (Object)e);
            }
        }
    }
}

