/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.PrioritizedFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLAction
implements ActionFactory,
PrioritizedFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLAction.class);
    private final Resource rule;
    private final int priority;

    public SCLAction(ReadGraph graph, Resource rule) throws DatabaseException {
        this.rule = rule;
        Integer p = (Integer)graph.getPossibleRelatedValue(rule, ModelingResources.getInstance((ReadGraph)graph).SCLAction_priority);
        this.priority = p != null ? p : 0;
    }

    public int priority() {
        return this.priority;
    }

    public Runnable create(Object target) {
        return new SCLActionRunnable(this.rule, (Resource)target);
    }

    static class RuleFunctionRequest
    extends ResourceRead<Function1<Resource, Object>> {
        protected RuleFunctionRequest(Resource rule) {
            super(rule);
        }

        public Function1<Resource, Object> perform(ReadGraph graph) throws DatabaseException {
            Variable ruleVariable = Variables.getVariable((ReadGraph)graph, (Resource)this.resource);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            return (Function1)ruleVariable.getPossiblePropertyValue(graph, MOD.SCLAction_action);
        }
    }

    public static class SCLActionRunnable
    implements Runnable {
        public Resource rule;
        public Resource target;

        public SCLActionRunnable(Resource rule, Resource target) {
            this.rule = rule;
            this.target = target;
        }

        @Override
        public void run() {
            Resource resource = this.target;
            Simantics.getSession().markUndoPoint();
            try {
                Function1 function = (Function1)Simantics.getSession().syncRequest((Read)new RuleFunctionRequest(this.rule));
                function.apply((Object)resource);
            }
            catch (DatabaseException e) {
                LOGGER.error("SCLActionRunnable failed to request/apply RuleFunction {}", (Object)this.rule, (Object)e);
            }
        }
    }
}

