/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialIC {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartialIC.class);
    public static Binding BINDING = Bindings.getBindingUnchecked(PartialIC.class);
    public RVI[] rvis = new RVI[0];
    public Variant[] variants = new Variant[0];

    public void add(RVI rvi, Variant value) {
        this.rvis = Arrays.copyOf(this.rvis, this.rvis.length + 1);
        this.rvis[this.rvis.length - 1] = rvi;
        this.variants = Arrays.copyOf(this.variants, this.variants.length + 1);
        this.variants[this.rvis.length - 1] = value;
    }

    public void apply(WriteGraph graph, Variable base) throws DatabaseException {
        if (this.rvis.length != this.variants.length) {
            throw new DatabaseException("PartialIC has broken RVI and Variant data arrays. Tried to apply to " + base.getURI((ReadGraph)graph));
        }
        int i = 0;
        while (i < this.rvis.length) {
            RVI rvi = this.rvis[i];
            Variant variant = this.variants[i];
            Variable v = rvi.resolvePossible((ReadGraph)graph, base);
            if (v != null) {
                v.setValue(graph, variant.getValue(), variant.getBinding());
            } else {
                LOGGER.warn("failed to resolve " + String.valueOf(rvi));
            }
            ++i;
        }
    }
}

