/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.InstantiateRequest;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;

public class NewComponentType {
    public static Resource createComponentType(WriteGraph graph, Resource library) throws DatabaseException {
        Resource symbolType;
        Resource symbolDiagramType;
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)library);
        Resource componentType = graph.newResource();
        graph.newClusterSet(componentType);
        CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)componentType);
        Layer0Utils.claimNewIdentifier((WriteGraph)graph, (Resource)componentType, (boolean)true);
        graph.claim(componentType, L0.PartOf, library);
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(library));
        Resource supertype = graph.getSingleObject(indexRoot, MOD.StructuralModel_HasComponentTypeSupertype);
        graph.claim(componentType, L0.Inherits, null, supertype);
        String defaultName = (String)graph.getRelatedValue(indexRoot, MOD.StructuralModel_HasDefaultComponentTypeName, (Binding)Bindings.STRING);
        String name = NameUtils.findFreshName((ReadGraph)graph, (String)defaultName, (Resource)library);
        graph.claimLiteral(componentType, L0.HasName, (Object)(name + "@1"));
        Resource substructureType = graph.getSingleObject(indexRoot, MOD.StructuralModel_HasComponentTypeSubstructureType);
        Resource composite = new InstantiateRequest(substructureType).perform(graph);
        graph.claim(componentType, STR.IsDefinedBy, composite);
        graph.claimLiteral(composite, L0.HasName, (Object)"Configuration");
        graph.claim(componentType, L0.ConsistsOf, composite);
        Resource diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
        if (diagram != null) {
            Resource componentTypeUpdater = graph.newResource();
            graph.claim(componentTypeUpdater, L0.InstanceOf, null, MOD.ComponentTypeUpdater);
            graph.claim(diagram, L0X.HasTrigger, componentTypeUpdater);
        }
        if ((symbolDiagramType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasSymbolDiagramType)) == null) {
            symbolDiagramType = DIA.Composite;
        }
        if ((symbolType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasSymbolType)) == null) {
            symbolType = DIA.DefinedElement;
        }
        Resource symbol = new ModelingUtils(graph).createSymbol2("Symbol", symbolDiagramType, symbolType);
        graph.claim(componentType, MOD.ComponentTypeToSymbol, symbol);
        graph.claim(componentType, L0.ConsistsOf, symbol);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Created new user component " + name + ", resource " + String.valueOf(componentType)));
        return componentType;
    }
}

