/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Stack;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.basicexpression.node.AConstantValue;
import org.simantics.basicexpression.node.ADivMultiplicative;
import org.simantics.basicexpression.node.AMinusExpression;
import org.simantics.basicexpression.node.AMultMultiplicative;
import org.simantics.basicexpression.node.APlusExpression;
import org.simantics.basicexpression.node.AVariablePrimary;
import org.simantics.utils.datastructures.Triple;

public class InvertBasicExpressionVisitorBase
extends DepthFirstAdapter {
    protected Stack<Object> stack = new Stack();

    public Object getResult() {
        if (this.stack.size() != 1) {
            return null;
        }
        return this.stack.pop();
    }

    public void outAConstantValue(AConstantValue node) {
        this.stack.push(Double.valueOf(node.toString()));
    }

    public void outAVariablePrimary(AVariablePrimary node) {
        String value = node.toString().trim();
        this.stack.push(Triple.make((Object)1.0, (Object)0.0, (Object)value));
    }

    public void outAPlusExpression(APlusExpression node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second + (Double)o1), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second + (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 + (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outAMinusExpression(AMinusExpression node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)((Double)p.first), (Object)((Double)p.second - (Double)o1), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)(-((Double)p.first).doubleValue()), (Object)((Double)o2 - (Double)p.second), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o2 - (Double)o1);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outAMultMultiplicative(AMultMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)((Double)p.first * (Double)o1), (Object)((Double)p.second * (Double)o1), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            Triple p = (Triple)o1;
            this.stack.push(Triple.make((Object)((Double)p.first * (Double)o2), (Object)((Double)p.second * (Double)o2), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o1 * (Double)o2);
        } else {
            this.stack.push(Double.NaN);
        }
    }

    public void outADivMultiplicative(ADivMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        if (o1 instanceof Double && o2 instanceof Triple) {
            Triple p = (Triple)o2;
            this.stack.push(Triple.make((Object)((Double)p.first / (Double)o1), (Object)((Double)p.second / (Double)o1), (Object)((String)p.third)));
        } else if (o2 instanceof Double && o1 instanceof Triple) {
            this.stack.push(Double.NaN);
        } else if (o2 instanceof Double && o1 instanceof Double) {
            this.stack.push((Double)o2 / (Double)o1);
        } else {
            this.stack.push(Double.NaN);
        }
    }
}

