/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.db.common.utils.VersionInfo;
import org.simantics.utils.strings.AlphanumComparator;

public class CreateVersionDialog
extends Dialog {
    private final VersionInfo info;
    private Label errors;
    private Text versionTxT;
    private String result;

    public CreateVersionDialog(Shell parentShell, VersionInfo info) {
        super(parentShell);
        this.info = info;
    }

    public String mutate(String ver) {
        try {
            int currentInt = Integer.parseInt(ver);
            return "" + (currentInt + 1);
        }
        catch (NumberFormatException numberFormatException) {
            if (ver.length() == 1) {
                char c = ver.charAt(0);
                Character ch = Character.valueOf(c = (char)(c + '\u0001'));
                if (Character.isLetter(ch.charValue()) && Character.isUpperCase(ch.charValue())) {
                    return ch.toString();
                }
            }
            return ver + "_1";
        }
    }

    public String getSuggestion() {
        String ver = this.info.version;
        while (this.validateVersion(ver) != null) {
            ver = this.mutate(ver);
        }
        return ver;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(2).applyTo(c);
        GridDataFactory gd1 = GridDataFactory.fillDefaults().span(2, 1);
        Label label = new Label(c, 0);
        label.setText("Current version identifier is: " + this.info.version);
        gd1.applyTo((Control)label);
        label = new Label(c, 0);
        label.setText("New identifier:");
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.versionTxT = new Text(c, 2048);
        this.versionTxT.setText(this.getSuggestion());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.versionTxT);
        this.versionTxT.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String result = CreateVersionDialog.this.validateVersion(CreateVersionDialog.this.versionTxT.getText());
                if (result != null) {
                    CreateVersionDialog.this.errors.setText(result);
                    CreateVersionDialog.this.getButton(0).setEnabled(false);
                    Shell shell = CreateVersionDialog.this.errors.getShell();
                    Point ns = shell.computeSize(-1, -1);
                    Point cs = shell.getSize();
                    shell.setSize(Math.max(cs.x, ns.x), Math.max(cs.y, ns.y));
                } else {
                    CreateVersionDialog.this.errors.setText("");
                    CreateVersionDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this.errors = new Label(c, 0);
        this.errors.setText("");
        this.errors.setForeground(this.errors.getDisplay().getSystemColor(3));
        gd1.applyTo((Control)this.errors);
        return c;
    }

    private String validateVersion(String version) {
        if (this.info.containsVersion(version)) {
            return "Version already in use";
        }
        if (AlphanumComparator.COMPARATOR.compare((Object)version, (Object)this.info.version) < 0) {
            return "New version must be lexically greater than current";
        }
        return null;
    }

    protected void okPressed() {
        this.result = this.versionTxT.getText();
        super.okPressed();
    }

    public String getResult() {
        return this.result;
    }

    protected int getShellStyle() {
        return 2160;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create new version of " + this.info.baseName);
    }
}

