/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.utils.ComponentTypeViewerPropertyInfo;
import org.simantics.modeling.utils.HeadlessComponentTypePropertiesResultRequest;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;

public class ContentDumps {
    private static Charset UTF8 = StandardCharsets.UTF_8;

    public static byte[] sclModuleContentDump(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String def = (String)graph.getRelatedValue(resource, L0.SCLModule_definition, (Binding)Bindings.STRING);
        return def.getBytes(UTF8);
    }

    public static byte[] sclScriptContentDump(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String def = (String)graph.getRelatedValue(resource, L0.SCLScript_definition, (Binding)Bindings.STRING);
        return def.getBytes(UTF8);
    }

    public static byte[] pgraphContentDump(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String def = (String)graph.getRelatedValue(resource, L0.PGraph_definition, (Binding)Bindings.STRING);
        return def.getBytes(UTF8);
    }

    public static byte[] graphFileContentDump(ReadGraph graph, Resource resource) throws DatabaseException {
        GraphFileResource GF = GraphFileResource.getInstance((ReadGraph)graph);
        return (byte[])graph.getRelatedValue(resource, GF.HasFiledata, (Binding)Bindings.BYTE_ARRAY);
    }

    private static StringBuilder structuralComponentContentDump(ReadGraph graph, Resource resource, StringBuilder dump) throws DatabaseException {
        Variable v = Variables.getVariable((ReadGraph)graph, (Resource)resource);
        TreeSet<String> types = new TreeSet<String>();
        for (Resource t : graph.getPrincipalTypes(resource)) {
            types.add(graph.getURI(t));
        }
        for (String uri : types) {
            dump.append(uri);
            dump.append("\n");
        }
        TreeMap<String, Variable> properties = new TreeMap<String, Variable>();
        for (Variable property : v.getProperties(graph)) {
            properties.put(property.getName(graph), property);
        }
        for (Variable property : properties.values()) {
            String possibleValue = (String)property.getPossiblePropertyValue(graph, "HasDisplayValue", (Binding)Bindings.STRING);
            if (possibleValue != null) {
                dump.append(property.getName(graph));
                dump.append(" ");
                dump.append(possibleValue);
                dump.append("\n");
            }
            if (!property.getClassifications(graph).contains("http://www.simantics.org/Structural-1.2/ConnectionRelation")) continue;
            dump.append(property.getName(graph));
            Connection c = (Connection)property.getValue(graph);
            TreeSet<String> rvis = new TreeSet<String>();
            for (VariableConnectionPointDescriptor desc : c.getConnectionPointDescriptors(graph, null)) {
                rvis.add(desc.getRelativeRVI(graph, v));
            }
            for (String rvi : rvis) {
                dump.append(" ");
                dump.append(rvi);
            }
            dump.append("\n");
        }
        return dump;
    }

    public static byte[] structuralComponentContentDump(ReadGraph graph, Resource resource) throws DatabaseException {
        return ContentDumps.structuralComponentContentDump(graph, resource, new StringBuilder()).toString().getBytes(UTF8);
    }

    public static byte[] structuralComponentTypeContentDump(ReadGraph graph, Resource resource) throws DatabaseException {
        Collection scripts;
        StringBuilder dump = ContentDumps.structuralComponentContentDump(graph, resource, new StringBuilder());
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        String proceduralCode = (String)graph.getPossibleRelatedValue(resource, STR.ProceduralComponentType_code, (Binding)Bindings.STRING);
        if (proceduralCode != null) {
            dump.append("\n---- ProceduralComponentType.code begins ----\n").append(proceduralCode).append("---- ProceduralComponentType.code ends ----\n");
        }
        if (!(scripts = graph.getObjects(resource, STR.ComponentType_hasScript)).isEmpty()) {
            dump.append("\nComponentType.hasScript (").append(scripts.size()).append(")\n");
            TreeMap<String, Resource> sortedScripts = new TreeMap<String, Resource>();
            for (Resource resource2 : scripts) {
                sortedScripts.put(NameUtils.getSafeName((ReadGraph)graph, (Resource)resource2), resource2);
            }
            for (Map.Entry entry : sortedScripts.entrySet()) {
                String name = (String)entry.getKey();
                Resource script = (Resource)entry.getValue();
                String type = (String)graph.getPossibleRelatedValue(script, STR.ComponentTypeScript_type, (Binding)Bindings.STRING);
                String code = (String)graph.getPossibleRelatedValue(script, STR.ComponentTypeScript_code, (Binding)Bindings.STRING);
                dump.append("---- script `").append(name).append("` of type `").append(type).append("` begins ----\n").append(code).append("\n---- script `").append(name).append("` of type `").append(type).append("` ends ----\n");
            }
        }
        return dump.toString().getBytes(UTF8);
    }

    public static byte[] genericParameterTypeContentDump(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource componentType = CommonDBUtils.possibleObjectWithType((ReadGraph)graph, (Resource)resource, (Resource)L0.PartOf, (Resource)STR.ComponentType);
        ComponentTypeViewerPropertyInfo pi = HeadlessComponentTypePropertiesResultRequest.readPropertyInfo(graph, resource, componentType, false);
        StringBuilder dump = new StringBuilder();
        dump.append(pi.type);
        dump.append(" ");
        dump.append(pi.defaultValue);
        if (pi.unit != null) {
            dump.append(" ");
            dump.append(pi.unit);
        }
        dump.append(" ");
        dump.append(pi.label);
        if (pi.description != null) {
            dump.append(" ");
            dump.append(pi.description);
        }
        return dump.toString().getBytes(UTF8);
    }
}

