/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;

public class AssignConnectionTypesRequest
extends WriteRequest {
    Collection<Resource> addedConnectionTypes;
    Collection<Resource> removedConnectionTypes;
    Collection<Resource> connectionPoints;

    public AssignConnectionTypesRequest(Collection<Resource> addedConnectionTypes, Collection<Resource> removedConnectionTypes, Collection<Resource> connectionPoints) {
        this.addedConnectionTypes = addedConnectionTypes;
        this.removedConnectionTypes = removedConnectionTypes;
        this.connectionPoints = connectionPoints;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        AssignConnectionTypesRequest.assignSymbolGroup(graph, this.addedConnectionTypes, this.removedConnectionTypes, this.connectionPoints);
    }

    public static void assignSymbolGroup(WriteGraph graph, Collection<Resource> addedConnectionTypes, Collection<Resource> removedConnectionTypes, Collection<Resource> connectionPoints) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource connectionPoint : connectionPoints) {
            for (Resource type : addedConnectionTypes) {
                graph.claim(connectionPoint, STR.AllowsConnectionType, type);
            }
            for (Resource type : removedConnectionTypes) {
                graph.deny(connectionPoint, STR.AllowsConnectionType, type);
            }
        }
    }
}

