/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import java.util.Collection;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.adapters.ChangeHistoryUpdated;
import org.simantics.modeling.adapters.ChangeInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologicalRequirementEnforceRequest
extends WriteRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntologicalRequirementEnforceRequest.class);
    private static final String PROP_WRITE_CHANGED_TAGS = "org.simantics.modeling.writeChangedTags";
    private Collection<Resource> creates;
    private Collection<Resource> modis;
    private Collection<Resource> ids;
    private String author;
    private long time;

    private static String getAuthor() {
        return System.getProperty("user.name", "");
    }

    private static boolean writeChangedTags() {
        return !System.getProperty(PROP_WRITE_CHANGED_TAGS, "").equalsIgnoreCase("false");
    }

    public OntologicalRequirementEnforceRequest(Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids) {
        this(creates, modis, ids, OntologicalRequirementEnforceRequest.getAuthor(), System.currentTimeMillis());
    }

    public OntologicalRequirementEnforceRequest(Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, String author, long time) {
        this.creates = creates;
        this.modis = modis;
        this.ids = ids;
        this.author = author;
        this.time = time;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        OntologicalRequirementEnforceRequest.update(graph, this.creates, this.modis, this.ids, true, this.author, this.time, true, OntologicalRequirementEnforceRequest.writeChangedTags(), true);
    }

    public static void update(WriteGraph graph, Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, boolean addComment, boolean disableDependencyIndexing) throws DatabaseException {
        OntologicalRequirementEnforceRequest.update(graph, creates, modis, ids, addComment, OntologicalRequirementEnforceRequest.getAuthor(), System.currentTimeMillis(), disableDependencyIndexing, OntologicalRequirementEnforceRequest.writeChangedTags(), true);
    }

    public static void update(WriteGraph graph, Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, boolean addComment, boolean disableDependencyIndexing, boolean setChangeHistoryUpdated) throws DatabaseException {
        OntologicalRequirementEnforceRequest.update(graph, creates, modis, ids, addComment, OntologicalRequirementEnforceRequest.getAuthor(), System.currentTimeMillis(), disableDependencyIndexing, OntologicalRequirementEnforceRequest.writeChangedTags(), setChangeHistoryUpdated);
    }

    public static void update(WriteGraph graph, Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, boolean addComment, String author, long time, boolean disableDependencyIndexing) throws DatabaseException {
        OntologicalRequirementEnforceRequest.update(graph, creates, modis, ids, addComment, author, time, disableDependencyIndexing, OntologicalRequirementEnforceRequest.writeChangedTags(), true);
    }

    public static void update(WriteGraph graph, Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, boolean addComment, String author, long time, boolean disableDependencyIndexing, boolean writeChangedTags) throws DatabaseException {
        OntologicalRequirementEnforceRequest.update(graph, creates, modis, ids, addComment, author, time, disableDependencyIndexing, writeChangedTags, true);
    }

    public static void update(WriteGraph graph, Collection<Resource> creates, Collection<Resource> modis, Collection<Resource> ids, boolean addComment, String author, long time, boolean disableDependencyIndexing, boolean writeChangedTags, boolean setChangeHistoryUpdated) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        boolean hasCreates = !creates.isEmpty();
        boolean hasModis = !modis.isEmpty();
        boolean trace = LOGGER.isTraceEnabled();
        if (trace) {
            LOGGER.trace("update(disable dependency indexing={}, hasCreates={}, hasModis={})", new Object[]{disableDependencyIndexing, hasCreates, hasModis});
        }
        int addedChangedInfos = 0;
        int updatedChangedInfos = 0;
        if (hasCreates) {
            ChangeInformation info = new ChangeInformation();
            info.createdAt = time;
            info.createdBy = author;
            info.modifiedAt = time;
            info.modifiedBy = author;
            for (Resource c : creates) {
                CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)c);
                graph.claimLiteral(c, MOD.changeInformation, MOD.changeInformation_Inverse, MOD.ChangeInformation, (Object)info, ChangeInformation.BINDING);
                ++addedChangedInfos;
            }
        }
        if (hasModis) {
            for (Resource m : modis) {
                ChangeInformation info = (ChangeInformation)graph.getPossibleRelatedValue(m, MOD.changeInformation, ChangeInformation.BINDING);
                if (info == null) {
                    info = new ChangeInformation();
                    info.createdAt = time;
                    info.createdBy = author;
                    ++addedChangedInfos;
                } else {
                    ++updatedChangedInfos;
                }
                info.modifiedAt = time;
                info.modifiedBy = author;
                CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)m);
                graph.claimLiteral(m, MOD.changeInformation, MOD.changeInformation_Inverse, MOD.ChangeInformation, (Object)info, ChangeInformation.BINDING);
            }
        }
        if (writeChangedTags && (hasCreates || hasModis)) {
            ModelingUtils.markChanged((RequestProcessor)graph, creates, modis);
        }
        int idCount = 0;
        for (Resource r : ids) {
            if (graph.hasStatement(r, L0.identifier)) continue;
            CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)r);
            Layer0Utils.claimNewIdentifier((WriteGraph)graph, (Resource)r, (boolean)true);
            if (trace) {
                LOGGER.trace("added identifier for {}", (Object)NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)r));
            }
            ++idCount;
        }
        if (disableDependencyIndexing && idCount == 0) {
            Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
        }
        if (addComment) {
            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
            if (hasCreates || hasModis) {
                cm.add("Added " + addedChangedInfos + " and updated " + updatedChangedInfos + " change informations");
            }
            if (idCount > 0) {
                cm.add("Added " + idCount + " missing identifiers");
            }
            graph.addMetadata((Metadata)cm);
        }
        if (setChangeHistoryUpdated) {
            graph.addMetadata(graph.getMetadata(ChangeHistoryUpdated.class));
        }
    }
}

