/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.subscription;

import java.util.UUID;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;

public class NewSubscription
extends WriteRequest {
    public Resource subscription;
    Resource model;
    String name;

    public NewSubscription(Resource model, String name) {
        this.model = model;
        this.name = name;
    }

    public void perform(WriteGraph g) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        ModelingResources wr = ModelingResources.getInstance((ReadGraph)g);
        String freshLabel = NameUtils.findFreshLabel((ReadGraph)g, (String)this.name, (Resource)this.model);
        this.subscription = GraphUtils.create2((WriteGraph)g, (Resource)wr.Subscription, (Object[])new Object[]{l0.HasName, UUID.randomUUID().toString(), l0.HasLabel, freshLabel, l0.PartOf, this.model});
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Created subscription folder " + this.name));
    }
}

