/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.services;

import java.nio.CharBuffer;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.services.ComponentNamingStrategy;
import org.simantics.modeling.services.ComponentNamingUtil;
import org.simantics.modeling.services.NamingException;

public abstract class ComponentNamingStrategyBase
implements ComponentNamingStrategy {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_NAME_MATCHING = false;
    protected final String generatedNameFormat;
    protected final boolean caseInsensitive;
    protected static final Comparator<Object> CASE_SENSITIVE_STRING_CHARBUFFER_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = null;
            String s2 = null;
            if (o1 instanceof String) {
                s1 = (String)o1;
            }
            if (o2 instanceof String) {
                s2 = (String)o2;
            }
            if (s1 != null && s2 != null) {
                return s1.compareTo((String)o2);
            }
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && o1 instanceof CharBuffer) {
                return -this.compare(s2, (CharBuffer)o1);
            }
            if (s2 == null && o2 instanceof CharBuffer) {
                return this.compare(s1, (CharBuffer)o2);
            }
            return 0;
        }

        @Override
        int compare(String s, CharBuffer buf) {
            int len1 = s.length();
            int len2 = buf.position();
            int n = Math.min(len1, len2);
            int k = 0;
            while (k < n) {
                char c2;
                char c1 = s.charAt(k);
                if (c1 != (c2 = buf.get(k))) {
                    return c1 - c2;
                }
                ++k;
            }
            return len1 - len2;
        }
    };
    protected static final Comparator<Object> CASE_INSENSITIVE_STRING_CHARBUFFER_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = null;
            String s2 = null;
            if (o1 instanceof String) {
                s1 = (String)o1;
            }
            if (o2 instanceof String) {
                s2 = (String)o2;
            }
            if (s1 != null && s2 != null) {
                return s1.compareToIgnoreCase((String)o2);
            }
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && o1 instanceof CharBuffer) {
                return -this.compare(s2, (CharBuffer)o1);
            }
            if (s2 == null && o2 instanceof CharBuffer) {
                return this.compare(s1, (CharBuffer)o2);
            }
            return 0;
        }

        @Override
        int compare(String s, CharBuffer buf) {
            int len1 = s.length();
            int len2 = buf.position();
            int n = Math.min(len1, len2);
            int k = 0;
            while (k < n) {
                char c2;
                char c1 = s.charAt(k);
                if (c1 != (c2 = buf.get(k)) && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
                ++k;
            }
            return len1 - len2;
        }
    };

    public ComponentNamingStrategyBase(String generatedNameFormat) {
        this(generatedNameFormat, true);
    }

    public ComponentNamingStrategyBase(String generatedNameFormat, boolean caseInsensitive) {
        this.generatedNameFormat = generatedNameFormat;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public String findFreshInstanceName(ReadGraph graph, Resource configurationRoot, Resource container, Resource componentType) throws NamingException, DatabaseException {
        String proposition = ComponentNamingUtil.generateProposition(graph, container, componentType);
        return this.validateInstanceName(graph, configurationRoot, container, componentType, proposition);
    }

    @Override
    public String validateInstanceName(ReadGraph graph, Resource configurationRoot, Resource container, Resource componentType, String proposition) throws NamingException, DatabaseException {
        return this.validateInstanceName(graph, configurationRoot, container, componentType, proposition, false);
    }

    @Override
    public List<String> validateInstanceNames(ReadGraph graph, Resource configurationRoot, List<String> propositions, boolean acceptProposition, Set<String> externallyReserved) throws NamingException, DatabaseException {
        throw new UnsupportedOperationException();
    }

    protected Comparator<Object> getComparator() {
        return ComponentNamingStrategyBase.getComparator(this.caseInsensitive);
    }

    protected static Comparator<Object> getComparator(boolean caseInsensitive) {
        return caseInsensitive ? CASE_INSENSITIVE_STRING_CHARBUFFER_COMPARATOR : CASE_SENSITIVE_STRING_CHARBUFFER_COMPARATOR;
    }

    protected Set<String> findStartsWithMatches(Set<String> matchUniverse, String proposition) {
        TreeSet<Object> result = new TreeSet<Object>(this.getComparator());
        if (matchUniverse.isEmpty()) {
            return result;
        }
        for (String name : matchUniverse) {
            if (!name.startsWith(proposition)) continue;
            result.add(name);
        }
        return result;
    }

    protected Set<String> findStartsWithMatches(Set<String> matchUniverse, String proposition, Set<String> result) {
        if (matchUniverse.isEmpty()) {
            return result;
        }
        for (String name : matchUniverse) {
            if (!name.startsWith(proposition)) continue;
            result.add(name);
        }
        return result;
    }

    protected String findFreshName(Set<String> allReservedNames, Set<String> allRequestedNames, String proposition, boolean acceptProposition) {
        if (allReservedNames == null) {
            throw new NullPointerException("null reserved name set");
        }
        if (proposition == null) {
            throw new NullPointerException("null proposition");
        }
        Set<String> startsWithMatches = this.findStartsWithMatches(allReservedNames, proposition);
        if (allRequestedNames != null) {
            this.findStartsWithMatches(allRequestedNames, proposition, startsWithMatches);
        }
        return this.findFreshName(startsWithMatches, proposition, acceptProposition);
    }

    protected String findFreshName(Set<String> reserved, String proposition, boolean acceptProposition) {
        return this.findFreshName(reserved, proposition, acceptProposition, this.generatedNameFormat);
    }

    protected String findFreshName(Set<String> reserved, String proposition, boolean acceptProposition, String nameFormat) {
        if (proposition == null) {
            throw new NullPointerException("null proposition");
        }
        if (acceptProposition && !reserved.contains(proposition)) {
            return proposition;
        }
        CharBuffer cb = CharBuffer.allocate(proposition.length() + 10);
        cb.mark();
        Formatter formatter = new Formatter(cb, Locale.US);
        int i = 1;
        while (true) {
            cb.reset();
            formatter.format(nameFormat, proposition, i);
            if (!reserved.contains(cb)) {
                cb.limit(cb.position());
                cb.rewind();
                String result = cb.toString();
                return result;
            }
            ++i;
        }
    }
}

