/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl.ontologymodule;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.scl.ontologymodule.SCLRelationInfo;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.db.SCLCompilationRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLRelationInfoRequest
extends BinaryRead<Resource, Environment, SCLRelationInfo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLRelationInfoRequest.class);

    private SCLRelationInfoRequest(Resource resource, Environment environment) {
        super((Object)resource, (Object)environment);
    }

    public SCLRelationInfo perform(ReadGraph graph) throws DatabaseException {
        Type type;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (!graph.isSubrelationOf((Resource)this.parameter, L0.HasProperty)) {
            return null;
        }
        String name = (String)graph.getPossibleRelatedValue((Resource)this.parameter, L0.HasName);
        if (name == null) {
            return null;
        }
        String valueType = (String)graph.getPossibleRelatedValue((Resource)this.parameter, L0.RequiresValueType);
        if (valueType == null) {
            Collection rangeTypes = graph.getObjects((Resource)this.parameter, L0.HasRange);
            if (rangeTypes.size() != 1) {
                LOGGER.warn("Couldn't find SCLtype for {} because it has multiple range types.", (Object)graph.getURI((Resource)this.parameter));
                return null;
            }
            Resource range = (Resource)rangeTypes.iterator().next();
            Collection assertedValueTypes = graph.getAssertedObjects(range, L0.HasValueType);
            if (assertedValueTypes.size() != 1) {
                LOGGER.warn("Couldn't find SCL type for {} because its range {} has multiple asserted value types.", (Object)graph.getURI((Resource)this.parameter), (Object)graph.getURI(range));
                return null;
            }
            Resource assertedValueType = (Resource)assertedValueTypes.iterator().next();
            valueType = (String)graph.getPossibleValue(assertedValueType, (Binding)Bindings.STRING);
            if (valueType == null) {
                LOGGER.warn("Couldn't find SCL type for {} because value type assertion of {} is missing a value.", (Object)graph.getURI((Resource)this.parameter), (Object)graph.getURI(range));
                return null;
            }
        }
        try {
            type = Environments.getType((Environment)((Environment)this.parameter2), (String)valueType);
        }
        catch (SCLExpressionCompilationException sCLExpressionCompilationException) {
            LOGGER.warn("Couldn't parse the value type of relation {}. Definition was '{}'.", (Object)graph.getURI((Resource)this.parameter), (Object)valueType);
            return null;
        }
        return new SCLRelationInfo(type, name);
    }

    public static SCLRelationInfo getRelationInfo(Resource resource, Environment environment) {
        try {
            return (SCLRelationInfo)SCLCompilationRequestProcessor.getRequestProcessor().syncRequest((Read)new SCLRelationInfoRequest(resource, environment), (Listener)TransientCacheListener.instance());
        }
        catch (DatabaseException e) {
            LOGGER.error("SCLRelationInfoRequest failed.", (Throwable)e);
            return null;
        }
    }
}

