/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.StatementEvaluation;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;
import org.simantics.diagram.synchronization.graph.GraphCopyAdvisor;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.layer0.Layer0;

public class ElementCopyAdvisor
extends GraphCopyAdvisor {
    G2DResource G2D;
    DiagramResource DIA;
    BiFunction<ReadGraph, Statement, StatementEvaluation> statementAdvisor = new BiFunction<ReadGraph, Statement, StatementEvaluation>(){

        @Override
        public StatementEvaluation apply(ReadGraph graph, Statement stm) {
            if (ElementCopyAdvisor.this.DIA.HasFlagType.equals(stm.getPredicate())) {
                return StatementEvaluation.INCLUDE;
            }
            if (ElementCopyAdvisor.this.G2D.HasFontStyle.equals(stm.getPredicate())) {
                return StatementEvaluation.INCLUDE;
            }
            return StatementEvaluation.USE_DEFAULT;
        }
    };

    public CopyAdvisor.Evaluation canCopy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourcecontainer, Resource targetContainer) throws DatabaseException {
        BasicResources br = (BasicResources)context.get(GraphSynchronizationHints.BASIC_RESOURCES);
        return graph.isInstanceOf(source, br.DIA.Element) ? CopyAdvisor.Evaluation.SUPPORTED : CopyAdvisor.Evaluation.NOT_SUPPORTED;
    }

    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        return this.copy(context, graph, source, sourceContainer, targetContainer, (Map<Object, Object>)new THashMap());
    }

    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer, Map<Object, Object> map) throws DatabaseException {
        Resource copy;
        Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(targetContainer));
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        this.G2D = G2DResource.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource resource = copy = model != null ? CopyAdvisorUtil.copy3((WriteGraph)graph, (Resource)source, (Resource)model, this.statementAdvisor, map) : CopyAdvisorUtil.copy2((WriteGraph)graph, (Resource)source, this.statementAdvisor, map);
        if (graph.hasStatement(sourceContainer, L0.ConsistsOf, source)) {
            graph.claim(targetContainer, L0.ConsistsOf, copy);
        }
        Layer0Utils.claimNewIdentifier((WriteGraph)graph, (Resource)copy, (boolean)false);
        return copy;
    }

    public Object cut(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (sourceContainer.equals(targetContainer)) {
            return null;
        }
        if (!OrderedSetUtils.remove((WriteGraph)graph, (Resource)sourceContainer, (Resource)source)) {
            throw new CancelTransactionException("Failed to unlink element " + NameUtils.getSafeName((ReadGraph)graph, (Resource)source) + " from source diagram " + NameUtils.getSafeName((ReadGraph)graph, (Resource)sourceContainer));
        }
        boolean prepend = graph.isInstanceOf(source, DIA.Connection);
        boolean add = true;
        add = prepend ? OrderedSetUtils.addFirst((WriteGraph)graph, (Resource)targetContainer, (Resource)source) : OrderedSetUtils.add((WriteGraph)graph, (Resource)targetContainer, (Resource)source);
        if (!add) {
            throw new CancelTransactionException("Failed to link element " + NameUtils.getSafeName((ReadGraph)graph, (Resource)source) + " to target diagram " + NameUtils.getSafeName((ReadGraph)graph, (Resource)targetContainer));
        }
        if (graph.hasStatement(sourceContainer, L0.ConsistsOf, source)) {
            graph.deny(sourceContainer, L0.ConsistsOf, source);
            graph.claim(targetContainer, L0.ConsistsOf, source);
        }
        return source;
    }
}

