/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.export;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.utils.traverser.TraverseQueryBuilder;
import org.simantics.db.common.utils.traverser.TraverseResult;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.DiscoverAction;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class DiscoverModels
implements DiscoverAction {
    public Read<Collection<String>> discoverRequest(final Collection<String> startLocations) throws ExportException {
        return new Read<Collection<String>>(){

            public Collection<String> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SimulationResource SIM = SimulationResource.getInstance((ReadGraph)graph);
                TraverseQueryBuilder builder = new TraverseQueryBuilder();
                builder.setStartResources((Collection)graph.syncRequest(ExportQueries.toResources((Collection)startLocations)));
                builder.followRelation(L0.ConsistsOf);
                builder.followAndReturnInstanceOf(SIM.Model);
                TraverseResult traverseResult = (TraverseResult)graph.syncRequest((Read)builder.build());
                return (Collection)graph.syncRequest(ExportQueries.toUris((Collection)traverseResult.result));
            }
        };
    }

    public Collection<String> discoverContent(ExportContext ctx, Collection<String> startLocations) throws ExportException {
        try {
            return (Collection)ctx.session.syncRequest(this.discoverRequest(startLocations));
        }
        catch (DatabaseException e) {
            if (e.getCause() instanceof ExportException) {
                throw (ExportException)e.getCause();
            }
            throw new ExportException((Throwable)e);
        }
    }
}

