/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNodeModification;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.g2d.nodes.SVGNodeAssignment;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.nodes.TargetedSVGNodeAssignment;
import org.simantics.scenegraph.g2d.nodes.TransformationAssignment;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;

public class SymbolCodeStyle
extends StyleBase<Pair<G2DNodeModification, Object>> {
    public Pair<G2DNodeModification, Object> calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Variable elementVariable = Variables.getPossibleVariable((ReadGraph)graph, (Resource)element);
        if (elementVariable == null) {
            return null;
        }
        Object modi = elementVariable.getPossiblePropertyValue(graph, DIA.symbolCode);
        if (modi == null && graph.isInstanceOf(element, DIA.RouteGraphConnection)) {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource connectionType = graph.getPossibleObject(element, STR.HasConnectionType);
            if (connectionType != null) {
                Variable connectionTypeVariable = Variables.getPossibleVariable((ReadGraph)graph, (Resource)connectionType);
                Function fn = (Function)connectionTypeVariable.getPossiblePropertyValue(graph, DIA.symbolFunction);
                modi = Simantics.applySCLRead((ReadGraph)graph, (Function1)fn, (Object)elementVariable);
            }
        }
        if (modi == null) {
            return null;
        }
        Object transform = graph.getPossibleRelatedValue(element, DIA.HasTransform);
        if (modi instanceof G2DNodeModification) {
            return Pair.make((Object)((G2DNodeModification)modi), (Object)transform);
        }
        if (modi instanceof List) {
            List styles = (List)modi;
            ArrayList<SVGNodeAssignment> assignments = new ArrayList<SVGNodeAssignment>(styles.size() / 3);
            int i = 0;
            while (i < styles.size() / 3) {
                assignments.add(new SVGNodeAssignment((String)styles.get(3 * i), (String)styles.get(3 * i + 1), (String)styles.get(3 * i + 2)));
                ++i;
            }
            return Pair.make((Object)new G2DNodeModification(assignments, Collections.emptyList()), (Object)transform);
        }
        throw new DatabaseException("Invalid symbolCode value: " + String.valueOf(modi));
    }

    private Map<Object, SingleElementNode> buildSingleElementMap(INode node) {
        HashMap<Object, SingleElementNode> elements = new HashMap<Object, SingleElementNode>();
        NodeUtil.forChildrenDeep((INode)node, SingleElementNode.class, n -> {
            elements.put(n.getKey(), (SingleElementNode)n);
            return null;
        });
        return elements;
    }

    public void applyStyleForNode(EvaluationContext evaluationContext, INode node, Pair<G2DNodeModification, Object> result) {
        if (result == null || result.first == null) {
            return;
        }
        Map<Object, SingleElementNode> elements = null;
        G2DNodeModification modification = (G2DNodeModification)result.first;
        if (node instanceof ConnectionNode) {
            INode child;
            if (modification.svgAssignments != null && !modification.svgAssignments.isEmpty() && (child = NodeUtil.getFirstChild((INode)node)) instanceof RouteGraphNode) {
                RouteGraphNode rgn = (RouteGraphNode)child;
                rgn.setAssignments(modification.svgAssignments);
            }
        } else if (node instanceof SingleElementNode) {
            HashMap assignmentMap = new HashMap();
            if (modification.svgAssignments != null && !modification.svgAssignments.isEmpty()) {
                for (SVGNode p : NodeUtil.collectNodes((INode)node, SVGNode.class)) {
                    ArrayList list = (ArrayList)assignmentMap.get(p);
                    if (list == null) {
                        list = new ArrayList();
                        assignmentMap.put(p, list);
                    }
                    list.addAll(modification.svgAssignments);
                }
            }
            if (modification.targetedSVGAssignments != null && !modification.targetedSVGAssignments.isEmpty()) {
                elements = this.buildSingleElementMap(node);
                for (TargetedSVGNodeAssignment ass : modification.targetedSVGAssignments) {
                    SingleElementNode sen = elements.get(ass.singleElementKey);
                    for (SVGNode p : NodeUtil.collectNodes((INode)sen, SVGNode.class)) {
                        ArrayList<TargetedSVGNodeAssignment> list = (ArrayList<TargetedSVGNodeAssignment>)assignmentMap.get(p);
                        if (list == null) {
                            list = new ArrayList<TargetedSVGNodeAssignment>();
                            assignmentMap.put(p, list);
                        }
                        list.add(ass);
                    }
                }
            }
            for (Map.Entry entry : assignmentMap.entrySet()) {
                SVGNode p = (SVGNode)entry.getKey();
                p.setAssignments((List)entry.getValue());
                p.cleanDiagramCache();
            }
            if (modification.transformAssignments != null) {
                HashMap<Object, AffineTransform> trs = new HashMap<Object, AffineTransform>();
                for (TransformationAssignment ass : modification.transformAssignments) {
                    trs.put(ass.key, ass.transform);
                }
                NodeUtil.forChildrenDeep((INode)node, SingleElementNode.class, n -> {
                    IG2DNode[] children;
                    Object key = n.getKey();
                    AffineTransform tr = (AffineTransform)trs.get(key);
                    if (tr != null && (children = n.getSortedNodes()).length > 0) {
                        children[0].setTransform(tr);
                    }
                    return null;
                });
            }
        }
    }
}

