/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.adapters.ConnectionRelationRemover;
import org.simantics.modeling.adapters.ElementRemover;
import org.simantics.modeling.utils.RemoverUtils;

public class FlagRemover
extends ElementRemover {
    public FlagRemover(Resource flag) {
        super(flag);
    }

    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        RemoverUtils.ValidationResult result;
        boolean lifted = FlagUtil.isLifted((ReadGraph)graph, (Resource)this.resource);
        if (lifted && (result = RemoverUtils.validateFlagRemoval(graph, this.resource)).inUse()) {
            return RemoverUtils.formatError(graph, result);
        }
        return null;
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        FlagUtil.disconnectFlag((WriteGraph)graph, (Resource)this.resource);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Collection<Object> connectionRelations = Collections.emptySet();
        if (FlagUtil.isLifted((ReadGraph)graph, (Resource)this.resource)) {
            connectionRelations = graph.getObjects(this.resource, DIA.IsLiftedAs);
        }
        this.removeElement(graph);
        if (!connectionRelations.isEmpty()) {
            for (Resource resource : connectionRelations) {
                new ConnectionRelationRemover(resource).remove(graph);
            }
        }
    }
}

