/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.common.NamedResource;
import org.simantics.ui.internal.Activator;
import org.simantics.utils.strings.AlphanumComparator;

public class NavigationTargetChooserDialog
extends Dialog {
    private static final String DIALOG = "NavigationTargetChooserDialog";
    private final NamedResource[] options;
    private final String title;
    private final String description;
    private NamedResource selected;
    private TableViewer viewer;
    private IDialogSettings dialogBoundsSettings;
    private final ViewerSorter sorter = new ViewerSorter(){

        public int category(Object element) {
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            NamedResource a1 = (NamedResource)e1;
            NamedResource a2 = (NamedResource)e2;
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)a1.getName(), (Object)a2.getName());
        }
    };

    public NavigationTargetChooserDialog(Shell parent, NamedResource[] options, String title, String description) {
        super(parent);
        this.options = options;
        this.title = title;
        this.description = description;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(DIALOG);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected void configureShell(Shell newShell) {
        if (this.title != null) {
            newShell.setText(this.title);
        } else {
            newShell.setText("Choose Navigation Target");
        }
        super.configureShell(newShell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Point getInitialSize() {
        Point result;
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
            return new Point(400, 500);
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.description != null) {
            Label label = new Label(composite, 0);
            label.setText(this.description);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.viewer = new TableViewer(composite, 2820);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TargetLabelProvider());
        this.viewer.setSorter(this.sorter);
        this.viewer.setInput((Object)this.options);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NavigationTargetChooserDialog.this.okPressed();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NavigationTargetChooserDialog.this.selectionChanged(event.getSelection());
            }
        });
        if (this.options.length > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.options[0]), true);
        }
        NavigationTargetChooserDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void selectionChanged(ISelection s) {
        Button ok = this.getButton(0);
        IStructuredSelection iss = (IStructuredSelection)s;
        if (iss == null || iss.isEmpty()) {
            if (ok != null) {
                ok.setEnabled(false);
            }
            return;
        }
        if (ok != null) {
            ok.setEnabled(true);
        }
    }

    protected void okPressed() {
        this.selected = (NamedResource)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        super.okPressed();
    }

    public NamedResource getSelection() {
        return this.selected;
    }

    class TargetLabelProvider
    extends LabelProvider {
        TargetLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            NamedResource a = (NamedResource)element;
            return a.getName();
        }
    }
}

