/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityNameModifier;
import org.simantics.db.layer0.adapter.impl.EntityStringModifierFactory;
import org.simantics.layer0.Layer0;

public class Rename {
    public static String renameNode(WriteGraph graph, Resource node, String newName) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource previousName = graph.getPossibleObject(node, L0.HasName);
        String nodeName = NameUtils.getSafeName((ReadGraph)graph, (Resource)node);
        EntityStringModifierFactory factory = new EntityStringModifierFactory(node);
        EntityNameModifier modifier = (EntityNameModifier)factory.createModifier((ReadGraph)graph, L0.HasName, previousName);
        String error = modifier.isValid(newName);
        if (error != null) {
            return error;
        }
        modifier.modify(graph, newName);
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Renamed node " + nodeName + ", resource  " + String.valueOf(node) + ", to " + newName));
        return "Successfully renamed " + nodeName + " to " + newName;
    }
}

