/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;

public final class ComponentUtils {
    public static boolean componentHasDiagram(ReadGraph g, Resource component) throws DatabaseException {
        return !ComponentUtils.getComponentDiagrams(g, component).isEmpty();
    }

    public static boolean compositeHasDiagram(ReadGraph g, Resource composite) throws DatabaseException {
        return !ComponentUtils.getCompositeDiagrams(g, composite).isEmpty();
    }

    public static Collection<Resource> getComponentDiagrams(ReadGraph g, Resource component) throws DatabaseException {
        Resource composite;
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        Resource componentType = g.getPossibleType(component, sr.Component);
        Resource resource = composite = componentType != null ? g.getPossibleObject(componentType, sr.IsDefinedBy) : null;
        if (composite != null) {
            return ComponentUtils.getCompositeDiagrams(g, composite);
        }
        return Collections.emptyList();
    }

    public static Collection<Resource> getCompositeDiagrams(ReadGraph g, Resource composite) throws DatabaseException {
        return g.getObjects(composite, ModelingResources.getInstance((ReadGraph)g).CompositeToDiagram);
    }

    public static Resource getCompositeDiagram(ReadGraph g, Resource composite) throws DatabaseException {
        return g.getSingleObject(composite, ModelingResources.getInstance((ReadGraph)g).CompositeToDiagram);
    }

    public static Resource getPossibleCompositeDiagram(ReadGraph g, Resource composite) throws DatabaseException {
        return g.getPossibleObject(composite, ModelingResources.getInstance((ReadGraph)g).CompositeToDiagram);
    }

    public static Resource getPossibleDiagramComposite(ReadGraph g, Resource diagram) throws DatabaseException {
        return g.getPossibleObject(diagram, ModelingResources.getInstance((ReadGraph)g).DiagramToComposite);
    }

    public static Collection<ResourceArray> formInputs(ReadGraph g, Resource compositeOrComponent) throws DatabaseException {
        ArrayList<ResourceArray> inputs;
        block3: {
            ResourceArray path;
            block2: {
                path = ComponentUtils.getStructuralPath(g, compositeOrComponent);
                inputs = new ArrayList<ResourceArray>();
                if (!ComponentUtils.compositeHasDiagram(g, compositeOrComponent)) break block2;
                for (Resource dia : ComponentUtils.getCompositeDiagrams(g, compositeOrComponent)) {
                    inputs.add(path.prepended(new Resource[]{dia}));
                }
                break block3;
            }
            if (!ComponentUtils.componentHasDiagram(g, compositeOrComponent)) break block3;
            for (Resource dia : ComponentUtils.getComponentDiagrams(g, compositeOrComponent)) {
                inputs.add(path.prepended(new Resource[]{dia}));
            }
        }
        return inputs;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ResourceArray getStructuralPath(ReadGraph g, Resource compositeOrComponent) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        Resource component = null;
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (g.isInstanceOf(compositeOrComponent, sr.Composite)) {
            component = compositeOrComponent;
        } else {
            if (!g.isInstanceOf(compositeOrComponent, sr.Component)) return ResourceArray.EMPTY;
            component = compositeOrComponent;
        }
        while (component != null) {
            result.add(component);
            Resource composite = g.getPossibleObject(component, b.PartOf);
            if (composite == null) {
                return new ResourceArray(result);
            }
            if (!g.isInstanceOf(composite, sr.Composite)) {
                return new ResourceArray(result);
            }
            component = composite;
        }
        return new ResourceArray(result);
    }

    public static Resource getCompositeConfigurationRoot(ReadGraph g, Resource composite) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(composite, sr.Composite)) {
            throw new IllegalArgumentException("argument " + NameUtils.getSafeName((ReadGraph)g, (Resource)composite) + " is not a composite component");
        }
        ResourceArray path = ComponentUtils.getStructuralPath(g, composite);
        if (path.isEmpty()) {
            return composite;
        }
        Resource topmostComponent = path.resources[path.resources.length - 1];
        return topmostComponent;
    }

    public static Resource getComponentConfigurationRoot(ReadGraph g, Resource component) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        if (g.isInstanceOf(component, sr.Composite)) {
            throw new IllegalArgumentException("argument " + NameUtils.getSafeName((ReadGraph)g, (Resource)component) + " is a composite component");
        }
        if (!g.isInstanceOf(component, sr.Component)) {
            throw new IllegalArgumentException("argument " + NameUtils.getSafeName((ReadGraph)g, (Resource)component) + " is not a component");
        }
        ResourceArray path = ComponentUtils.getStructuralPath(g, component);
        Resource topmostComponent = path.isEmpty() ? component : path.resources[path.resources.length - 1];
        return topmostComponent;
    }

    public static Resource tryGetComponentContainer(ReadGraph g, Resource component) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        if (g.isInstanceOf(component, sr.Composite)) {
            throw new IllegalArgumentException("argument " + NameUtils.getSafeName((ReadGraph)g, (Resource)component) + " is a composite component");
        }
        if (!g.isInstanceOf(component, sr.Component)) {
            throw new IllegalArgumentException("argument " + NameUtils.getSafeName((ReadGraph)g, (Resource)component) + " is not a component");
        }
        Resource container = g.getPossibleObject(component, l0.PartOf);
        if (container == null) {
            return null;
        }
        return container;
    }

    public static Resource tryGetComponentConfigurationRoot(ReadGraph g, Resource component) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        if (g.isInstanceOf(component, sr.Composite)) {
            return null;
        }
        if (!g.isInstanceOf(component, sr.Component)) {
            return null;
        }
        ResourceArray path = ComponentUtils.getStructuralPath(g, component);
        Resource topmostComponent = path.isEmpty() ? component : path.resources[path.resources.length - 1];
        return topmostComponent;
    }

    public static List<Resource> getCompositePathToConfiguration(ReadGraph graph, Resource composite) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        LinkedList<Resource> compositePath = new LinkedList<Resource>();
        while (!graph.hasStatement(composite, SIMU.IsConfigurationOf)) {
            compositePath.addFirst(composite);
            composite = graph.getPossibleObject(composite, L0.PartOf);
            if (composite != null) continue;
            return null;
        }
        return compositePath;
    }
}

