/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.view;

import java.util.Collection;
import java.util.Date;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.All;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.adapters.ChangeInformation;
import org.simantics.modeling.subscription.SubscriptionItemLabel;
import org.simantics.utils.format.ValueFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bean {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bean.class);
    public String createdBy = "";
    public String modifiedBy = "";
    public long modifiedAt = 0L;
    public long createdAt = 0L;
    public String name = "";
    public String path = "";
    public String types = "";

    public Bean() {
    }

    public Bean(ReadGraph graph, Resource r, ChangeInformation i, String baseURI) throws DatabaseException {
        Object name;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
        Collection principalTypes = graph.getPrincipalTypes(r);
        if (principalTypes.contains(MOD.Subscription)) {
            label = (String)graph.getPossibleRelatedValue2(r, L0.HasLabel, (Binding)Bindings.STRING);
            this.setName(label != null && !label.isEmpty() ? label : "<unnamed subscription>");
        } else if (principalTypes.contains(MOD.Subscription_Item)) {
            label = SubscriptionItemLabel.resolveLabel((ReadGraph)graph, (Resource)r, (ValueFormat)ValueFormat.Default, (boolean)true, (boolean)true, (boolean)false);
            this.setName(label);
        } else if (principalTypes.contains(CHART.Chart_Item)) {
            label = (String)graph.getPossibleRelatedValue2(r, L0.HasLabel, (Binding)Bindings.STRING);
            this.setName(label != null && !label.isEmpty() ? label : "<unlabeled chart item>");
        } else {
            Resource possibleComponent = graph.getPossibleObject(r, MOD.ElementToComponent);
            Resource possibleComposite = graph.getPossibleObject(r, MOD.DiagramToComposite);
            Resource nameResource = r;
            if (possibleComponent != null) {
                nameResource = possibleComponent;
            }
            if (possibleComposite != null) {
                nameResource = possibleComposite;
            }
            name = Versions.getStandardNameString((ReadGraph)graph, (Resource)nameResource);
            if (possibleComponent != null) {
                name = (String)name + " Element";
            }
            if (possibleComposite != null) {
                name = (String)name + " Diagram";
            }
            this.setName((String)name);
        }
        StringBuilder types = new StringBuilder();
        for (Resource t : principalTypes) {
            if (types.length() > 0) {
                types.append(" ");
            }
            types.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)t));
        }
        this.setTypes(types.toString());
        Resource parent = graph.getPossibleObject(r, L0.PartOf);
        if (parent != null) {
            String uri = graph.getPossibleURI(parent);
            if (uri != null) {
                if (uri.endsWith("/__CONTAINER__/__DIAGRAM__")) {
                    uri = uri.substring(0, uri.length() - "/__CONTAINER__/__DIAGRAM__".length());
                }
                if (uri.endsWith("/__CONTAINER__")) {
                    uri = uri.substring(0, uri.length() - "/__CONTAINER__".length());
                }
                if (uri.equals(baseURI)) {
                    uri = "<selected resource>";
                }
                if (uri.startsWith(baseURI)) {
                    uri = uri.substring(baseURI.length());
                }
                if (uri.startsWith("/Configuration/")) {
                    uri = uri.substring("/Configuration/".length());
                }
                uri = uri.replace("http://Projects/Development%20Project/", "");
                uri = URIStringUtils.unescape((String)uri);
                if (graph.isInstanceOf(parent, MOD.Subscription)) {
                    name = (String)graph.getPossibleRelatedValue(parent, L0.HasName, (Binding)Bindings.STRING);
                    String label = (String)graph.getPossibleRelatedValue(parent, L0.HasLabel, (Binding)Bindings.STRING);
                    uri = uri.replace((CharSequence)name, label);
                }
                this.setPath(uri);
            } else {
                LOGGER.warn("Could not resolve path (URI) for parent resource {} of child {}", (Object)parent, (Object)r);
                this.setPath("");
            }
        } else {
            this.setPath("");
        }
        this.setCreatedBy(i.createdBy);
        this.setModifiedBy(i.modifiedBy);
        this.setModifiedAt(i.modifiedAt);
        this.setCreatedAt(i.createdAt);
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getModifiedAt() {
        return All.sdfLong.format(new Date(this.modifiedAt));
    }

    public void setModifiedAt(long modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getCreatedAt() {
        return All.sdfLong.format(new Date(this.createdAt));
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }
}

