/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.typicals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.AvailableSynchronizationRules;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.datastructures.Arrays;
import org.simantics.utils.strings.AlphanumComparator;

public class RuleChooserDialog
extends Dialog {
    private static final String DIALOG = "RuleChooserDialog";
    private static final String LAST_SELECTION = "LastSelection";
    private final NamedResource[] rules;
    private final String title;
    private final String description;
    private Collection<NamedResource> selectedRules;
    private boolean loggingEnabled = false;
    private TableViewer viewer;
    private Button logEnabled;
    private IDialogSettings dialogBoundsSettings;
    private ResourceManager resourceManager;
    private final Comparator<NamedResource> sorter = new Comparator<NamedResource>(){

        @Override
        public int compare(NamedResource nr1, NamedResource nr2) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)nr1.getName(), (Object)nr2.getName());
        }
    };

    public RuleChooserDialog(Shell parent, String description, Collection<NamedResource> rules) {
        super(parent);
        this.rules = rules.toArray(new NamedResource[rules.size()]);
        java.util.Arrays.sort(this.rules, this.sorter);
        this.title = "Choose Synchronization Rules";
        this.description = description;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(DIALOG);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(DIALOG);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected void configureShell(Shell newShell) {
        if (this.title != null) {
            newShell.setText(this.title);
        } else {
            newShell.setText("Choose Action");
        }
        super.configureShell(newShell);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Point getInitialSize() {
        Point result;
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
            return new Point(500, 500);
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Object[] lastChecked;
        Composite composite = (Composite)super.createDialogArea(parent);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        composite.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                RuleChooserDialog.this.resourceManager.dispose();
                RuleChooserDialog.this.resourceManager = null;
            }
        });
        if (this.description != null) {
            Text label = new Text(composite, 74);
            label.setBackground(composite.getBackground());
            label.setText(this.description);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        this.viewer = new TableViewer(composite, 2852);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.viewer.setInput((Object)this.rules);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RuleChooserDialog.this.selectionChanged(event.getSelection());
            }
        });
        this.logEnabled = new Button(composite, 32);
        this.logEnabled.setText("Verbose synchronization logging");
        if (this.rules.length > 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.rules[0]), true);
            this.viewer.getTable().setFocus();
        }
        if ((lastChecked = this.dialogBoundsSettings.getArray(LAST_SELECTION)) != null) {
            TableItem[] tableItemArray = this.viewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                NamedResource nr = (NamedResource)item.getData();
                if (Arrays.contains((Object[])lastChecked, (Object)nr.getName())) {
                    item.setChecked(true);
                }
                ++n2;
            }
        }
        RuleChooserDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void selectionChanged(ISelection s) {
        Button ok = this.getButton(0);
        IStructuredSelection iss = (IStructuredSelection)s;
        if (iss == null || iss.isEmpty()) {
            if (ok != null) {
                ok.setEnabled(false);
            }
            return;
        }
        if (ok != null) {
            ok.setEnabled(true);
        }
    }

    protected void okPressed() {
        ArrayList<String> names = new ArrayList<String>();
        this.selectedRules = new ArrayList<NamedResource>();
        TableItem[] tableItemArray = this.viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                NamedResource nr = (NamedResource)item.getData();
                this.selectedRules.add(nr);
                names.add(nr.getName());
            }
            ++n2;
        }
        this.loggingEnabled = this.logEnabled.getSelection();
        this.dialogBoundsSettings.put(LAST_SELECTION, names.toArray(new String[names.size()]));
        super.okPressed();
    }

    public Collection<NamedResource> getSelectedRules() {
        return this.selectedRules;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public static RuleResult choose(Shell shell, String description, final Resource[] input) throws DatabaseException {
        final HashSet<NamedResource> rules = new HashSet<NamedResource>();
        final HashSet alwaysEnabledRules = new HashSet();
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Resource[] resourceArray = input;
                int n = input.length;
                int n2 = 0;
                while (n2 < n) {
                    Resource r = resourceArray[n2];
                    Collection nrs = (Collection)graph.syncRequest((Read)new AvailableSynchronizationRules(r));
                    for (NamedResource nr : nrs) {
                        boolean alwaysEnabled = Boolean.TRUE.equals(graph.getPossibleRelatedValue(nr.getResource(), MOD.TypicalSynchronizationRule_alwaysEnabled, (Binding)Bindings.BOOLEAN));
                        if (alwaysEnabled) {
                            alwaysEnabledRules.add(nr.getResource());
                            continue;
                        }
                        rules.add(nr);
                    }
                    ++n2;
                }
            }
        });
        description = (String)description + "\n\nChecked rules will be applied in addition to default rules.";
        RuleChooserDialog dialog = new RuleChooserDialog(shell, (String)description, rules);
        int ret = dialog.open();
        if (ret != 0) {
            return null;
        }
        Collection<NamedResource> selectedRules = dialog.getSelectedRules();
        HashSet<Resource> selectedRuleResources = new HashSet<Resource>();
        for (NamedResource nr : selectedRules) {
            selectedRuleResources.add(nr.getResource());
        }
        selectedRuleResources.addAll(alwaysEnabledRules);
        return new RuleResult(selectedRuleResources, dialog.isLoggingEnabled());
    }

    class RuleLabelProvider
    extends LabelProvider {
        RuleLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            NamedResource nr = (NamedResource)element;
            return nr.getName();
        }
    }

    public static class RuleResult {
        public final Set<Resource> selectedRules;
        public final boolean logging;

        RuleResult(Set<Resource> selectedRules, boolean logging) {
            this.selectedRules = selectedRules;
            this.logging = logging;
        }
    }
}

