/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.scriptEditor;

import org.simantics.Simantics;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.modeling.ui.scl.scriptEditor.WriteSCLScriptDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SCLScriptSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScriptSource.class);
    private String scriptURI;
    private String scriptText;

    public SCLScriptSource(String scriptURI, String scriptText) {
        this.scriptURI = scriptURI;
        this.scriptText = scriptText;
    }

    public void update(String newSourceText) {
        try {
            Simantics.getSession().syncRequest((Write)new WriteSCLScriptDefinition(this.scriptURI, newSourceText));
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to write SCL script source from " + this.scriptURI, (Throwable)e);
        }
    }

    public boolean isUpdateable() {
        return true;
    }

    public String getSourceText() {
        return this.scriptText;
    }

    public String getScriptURI() {
        return this.scriptURI;
    }
}

