/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.modeling.ui.scl.scriptEditor.SCLScriptAnnotationModel;
import org.simantics.modeling.ui.scl.scriptEditor.SCLScriptEditorInput;
import org.simantics.modeling.ui.scl.scriptEditor.SCLScriptSource;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor2.SCLPartitionScanner;

public class SCLScriptEditorDocumentProvider
extends AbstractDocumentProvider {
    private SCLSourceViewerConfigurationNew sourceViewer;
    protected AnnotationModel annotationModel = new AnnotationModel();
    private Object currentElement;
    private SCLScriptSource currentSource;

    public SCLScriptEditorDocumentProvider(SCLSourceViewerConfigurationNew sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    private void updateScriptSource(Object input) {
        if (this.currentElement != null && this.currentElement.equals(input)) {
            return;
        }
        this.currentElement = input;
        if (!(this.currentElement instanceof SCLScriptEditorInput)) {
            return;
        }
        SCLScriptSource source = ((SCLScriptEditorInput)this.currentElement).getAdapter(SCLScriptSource.class);
        if (source != null) {
            this.currentSource = source;
        }
    }

    protected IDocument createDocument(Object element) throws CoreException {
        this.updateScriptSource(element);
        if (this.currentSource == null) {
            throw new CoreException((IStatus)new Status(4, "org.simantics.scl.ui", "Source for the SCL module could not be found."));
        }
        Document document = new Document(this.currentSource.getSourceText());
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SCLPartitionScanner(), SCLPartitionScanner.PARTITION_TYPES);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.sourceViewer.updateCompletionAssistModuleName(this.currentSource.getScriptURI());
        return document;
    }

    public void changed(Object element) {
        this.updateScriptSource(element);
    }

    public void aboutToChange(Object element) {
        super.aboutToChange(element);
    }

    public boolean isModifiable(Object element) {
        if (this.currentSource == null) {
            return false;
        }
        return this.currentSource.isUpdateable();
    }

    public boolean isReadOnly(Object element) {
        return !this.isModifiable(element);
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        SCLScriptEditorInput input = (SCLScriptEditorInput)element;
        return new SCLScriptAnnotationModel(input, SCLOsgi.MODULE_REPOSITORY);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (this.currentSource != null) {
            this.currentSource.update(document.get());
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }
}

