/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property.svg;

import java.util.Set;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.modeling.ui.property.svg.SVGInput;
import org.simantics.modeling.ui.property.svg.XMLPrettyPrinter;

public class SVGTextFactory
extends ReadFactoryImpl<SVGInput, String> {
    public String perform(ReadGraph graph, SVGInput input) throws DatabaseException {
        Resource res = (Resource)input.getDatum();
        String possibleText = this.possibleSVGText(graph, res);
        if (possibleText != null) {
            return XMLPrettyPrinter.safePrettyPrint(possibleText);
        }
        return "";
    }

    private String possibleSVGText(ReadGraph graph, Resource res) throws DatabaseException {
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ImageResource IMG = ImageResource.getInstance((ReadGraph)graph);
        Set types = graph.getTypes(res);
        if (types.contains(DIA.SVGElement)) {
            return (String)graph.getPossibleRelatedValue(res, G2D.HasSVGDocument, (Binding)Bindings.STRING);
        }
        if (types.contains(IMG.SvgImage)) {
            return (String)graph.getPossibleValue(res, (Binding)Bindings.STRING);
        }
        return null;
    }
}

