/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.property.svg;

import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.DefaultColorProvider;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.modeling.ui.property.svg.SVGInput;
import org.simantics.modeling.ui.property.svg.SVGModifier;
import org.simantics.modeling.ui.property.svg.SVGTextFactory;
import org.simantics.modeling.ui.property.svg.XMLPrettyPrinter;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.ConfigurationComposite;
import org.simantics.selectionview.PropertyTabContributor;
import org.simantics.selectionview.TabContribution;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

public class SVGElementComposite
extends ConfigurationComposite {
    public static TabContribution<Object> svgTabContribution() {
        return new TabContribution<Object>(){

            public boolean accept(ReadGraph graph, Object input) throws DatabaseException {
                Resource res = WorkbenchSelectionUtils.getPossibleResourceFromSelection((RequestProcessor)graph, (Object)input);
                if (res == null) {
                    return false;
                }
                if (graph.isInstanceOf(res, DiagramResource.getInstance((ReadGraph)graph).SVGElement)) {
                    return true;
                }
                return graph.isInstanceOf(res, ImageResource.getInstance((ReadGraph)graph).SvgImage);
            }

            public void contribute(ReadGraph graph, Object selection, Collection<ComparableTabContributor> result) throws DatabaseException {
                Resource res = WorkbenchSelectionUtils.getPossibleResourceFromSelection((RequestProcessor)graph, (Object)selection);
                if (res != null) {
                    if (graph.isInstanceOf(res, DiagramResource.getInstance((ReadGraph)graph).SVGElement)) {
                        result.add(SVGElementComposite.make(res, 100.0, "SVG"));
                    }
                    if (graph.isInstanceOf(res, ImageResource.getInstance((ReadGraph)graph).SvgImage)) {
                        result.add(SVGElementComposite.make(res, 100.0, "SVG"));
                    }
                }
            }
        };
    }

    public static ComparableTabContributor make(Resource input, double priority, String tabLabel) {
        return SVGElementComposite.make(new SVGInput(input), priority, tabLabel);
    }

    public static ComparableTabContributor make(SVGInput input, double priority, String tabLabel) {
        return new ComparableTabContributor((PropertyTabContributor)new SVGElementComposite(), priority, (Object)input, tabLabel);
    }

    public void create(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        Display display = body.getDisplay();
        body.setBackground(display.getSystemColor(1));
        Label expressionHeader = new Label(body, support, 0);
        expressionHeader.setText("SVG markup");
        expressionHeader.setFont(this.smallFont);
        expressionHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000000, 0x1000000).applyTo((Control)expressionHeader.getWidget());
        TrackedText expression = new TrackedText(body, support, 2562);
        expression.setSelectAllOnStartEdit(false);
        expression.setColorProvider((ITrackedColorProvider)new DefaultColorProvider(expression.getResourceManager()){
            private final ColorDescriptor inactiveColor;
            {
                this.inactiveColor = ColorDescriptor.createFrom((RGB)new RGB(220, 220, 255));
            }

            public Color getInactiveBackground() {
                return SVGElementComposite.this.resourceManager.createColor(this.inactiveColor);
            }
        });
        expression.setTextFactory((ReadFactory)new SVGTextFactory());
        expression.addModifyListener((TextModifyListener)new SVGModifier());
        expression.setInputValidator(new IInputValidator(){

            public String isValid(String document) {
                try {
                    XMLPrettyPrinter.parseDocument(document);
                    return null;
                }
                catch (Exception e) {
                    return e.getMessage();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)expression.getWidget());
    }
}

