/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.preferences;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.simantics.diagram.connection.rendering.ConnectionCrossings;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;

public final class DiagramPreferences {
    public static final String P_SNAP_GRID_SIZE = "grid.size";
    public static final String P_DEFAULT_PAGE_SIZE = "page.default.size";
    public static final String P_DISPLAY_PAGE_SIZE = "page.display.size";
    public static final String P_DISPLAY_MARGINS = "page.display.margins";
    public static final String P_DISPLAY_GRID = "page.display.grid";
    public static final String P_DISPLAY_RULER = "page.display.ruler";
    public static final String P_DEFAULT_CONNECTION_CROSSING_STYLE = "page.default.connection.crossing.style";
    public static final String P_DEFAULT_CONNECTION_CROSSING_WIDTH = "page.default.connection.crossing.width";
    public static final String P_MAXIMUM_AMOUNT_OF_OPEN_DIAGRAMS = "diagram.maxOpen";
    public static final String P_DISPOSE_DIAGRAMS_OVER_TIME = "diagram.disposeOverTime";
    public static final String P_DIAGRAM_DISPOSE_WAIT_TIME = "diagram.disposeWaitTime";
    public static final MarginUtils.Margin MARGIN_10MM = new MarginUtils.Margin(0.0, 0.0, 10.0);
    public static final Double DEFAULT_SNAP_GRID_SIZE = 1.0;
    public static final PageOrientation DEFAULT_PAGE_ORIENTATION = PageOrientation.Landscape;
    public static final MarginUtils.Margins DEFAULT_PAGE_MARGINS = new MarginUtils.Margins(MARGIN_10MM, MARGIN_10MM, MARGIN_10MM, MARGIN_10MM);
    public static final PageDesc DEFAULT_PAGE_SIZE = PageDesc.DEFAULT.withOrientation(DEFAULT_PAGE_ORIENTATION).withMargins(DEFAULT_PAGE_MARGINS);
    public static final Boolean DEFAULT_DISPLAY_PAGE_SIZE = Boolean.TRUE;
    public static final Boolean DEFAULT_DISPLAY_MARGINS = Boolean.TRUE;
    public static final Boolean DEFAULT_DISPLAY_GRID = Boolean.FALSE;
    public static final Boolean DEFAULT_DISPLAY_RULER = Boolean.FALSE;
    public static final String DEFAULT_CONNECTION_CROSSING_STYLE = ConnectionCrossings.Type.NONE.toString();
    public static final Double DEFAULT_CONNECTION_CROSSING_WIDTH = 1.5;
    public static final int DEFAULT_MAXIMUM_AMOUNT_OF_OPEN_DIAGRAMS = 8;
    public static final boolean DEFAULT_DISPOSE_DIAGRAMS_OVER_TIME = true;
    public static final int DEFAULT_DIAGRAM_DISPOSE_WAIT_TIME = 30;
    public final IEclipsePreferences preferences;
    private final Map<String, Object> map;

    public DiagramPreferences(IEclipsePreferences preferences, Map<String, Object> map) {
        this.preferences = preferences;
        this.map = map;
        if (map == null) {
            map = Collections.emptyMap();
        }
    }

    public DiagramPreferences withValue(String preference, Object value) {
        HashMap<String, Object> newMap = new HashMap<String, Object>(this.map);
        newMap.put(preference, value);
        return new DiagramPreferences(this.preferences, newMap);
    }

    public <T> T get(String preference) {
        Object t = this.map.get(preference);
        if (t == null) {
            throw new IllegalStateException("no value for preference " + preference + " available");
        }
        return (T)t;
    }

    public PageDesc getCompletePageDesc() {
        PageDesc pd = (PageDesc)this.get(P_DEFAULT_PAGE_SIZE);
        return pd;
    }

    public DiagramDesc getDiagramDesc() {
        double gridSize = (Double)this.get(P_SNAP_GRID_SIZE);
        boolean bordersVisible = (Boolean)this.get(P_DISPLAY_PAGE_SIZE);
        boolean marginsVisible = (Boolean)this.get(P_DISPLAY_MARGINS);
        boolean gridVisible = (Boolean)this.get(P_DISPLAY_GRID);
        boolean rulerVisible = (Boolean)this.get(P_DISPLAY_RULER);
        return new DiagramDesc(this.getCompletePageDesc(), gridSize, bordersVisible, marginsVisible, gridVisible, rulerVisible);
    }
}

