/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.flag.DiagramFlagPreferences;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.utils.ui.ExceptionUtils;

public class DiagramFlagPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private SchemeSelector scheme;
    private List<LabelingScheme> schemes;

    public DiagramFlagPreferencePage() {
        super(0);
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
    }

    protected void createFieldEditors() {
        LabelingScheme s;
        this.schemes = Collections.emptyList();
        Resource schemeValue = null;
        try {
            this.schemes = (List)Simantics.getSession().syncRequest((Read)new FindSchemes());
            schemeValue = DiagramFlagPreferences.getActiveFlagLabelingSchemeResource((RequestProcessor)Simantics.getSession());
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
        LabelingScheme previousValue = null;
        LabelingScheme defaultValue = null;
        int i = 0;
        while (i < this.schemes.size()) {
            s = this.schemes.get(i);
            if ("http://www.simantics.org/Diagram-2.2/FlagLabelingScheme/Alphabetical".equals(s.getURI())) {
                defaultValue = s;
            }
            ++i;
        }
        if (defaultValue == null && !this.schemes.isEmpty()) {
            defaultValue = this.schemes.get(0);
        }
        if (schemeValue != null) {
            i = 0;
            while (i < this.schemes.size()) {
                s = this.schemes.get(i);
                if (schemeValue.equals(s.getResource())) {
                    previousValue = s;
                }
                ++i;
            }
        }
        if (previousValue == null) {
            previousValue = defaultValue;
        }
        this.scheme = new SchemeSelector("Labeling Scheme", this.schemes, previousValue, defaultValue, this.getFieldEditorParent());
        this.addField(this.scheme);
    }

    static class FindSchemes
    implements Read<List<LabelingScheme>> {
        FindSchemes() {
        }

        public List<LabelingScheme> perform(ReadGraph graph) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ArrayList<LabelingScheme> result = new ArrayList<LabelingScheme>();
            for (Resource scheme : (Collection)graph.syncRequest((Read)new ObjectsWithType(DIA.FlagLabelingScheme, L0.ConsistsOf, DIA.FlagLabelingScheme))) {
                String label = (String)graph.adapt(scheme, String.class);
                String description = (String)graph.getPossibleRelatedValue(scheme, L0.HasDescription);
                String uri = graph.getURI(scheme);
                result.add(new LabelingScheme(label, description, uri, scheme));
            }
            return result;
        }
    }

    static class LabelingScheme
    extends Tuple {
        public LabelingScheme(String label, String description, String uri, Resource scheme) {
            super(new Object[]{label, description, uri, scheme});
        }

        public String getLabel() {
            return (String)this.getField(0);
        }

        public String getDescription() {
            return (String)this.getField(1);
        }

        public String getURI() {
            return (String)this.getField(2);
        }

        public Resource getResource() {
            return (Resource)this.getField(3);
        }
    }

    static class SchemeSelector
    extends FieldEditor {
        private Combo fCombo;
        private LabelingScheme fValue;
        private LabelingScheme fOriginalValue;
        private LabelingScheme fDefaultValue;
        private List<LabelingScheme> fValues;

        public SchemeSelector(String labelText, List<LabelingScheme> values, LabelingScheme originalValue, LabelingScheme defaultValue, Composite parent) {
            this.init("labelingScheme", labelText);
            this.fValues = values;
            this.fOriginalValue = originalValue;
            this.fDefaultValue = defaultValue;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            if (numColumns > 1) {
                Label control = this.getLabelControl();
                int left = numColumns;
                if (control != null) {
                    ((GridData)control.getLayoutData()).horizontalSpan = 1;
                    --left;
                }
                ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
            } else {
                Label control = this.getLabelControl();
                if (control != null) {
                    ((GridData)control.getLayoutData()).horizontalSpan = 1;
                }
                ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
            }
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            int comboC = 1;
            if (numColumns > 1) {
                comboC = numColumns - 1;
            }
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            control.setLayoutData((Object)gd);
            control = this.getComboBoxControl(parent);
            gd = new GridData();
            gd.horizontalSpan = comboC;
            gd.horizontalAlignment = 4;
            control.setLayoutData((Object)gd);
            control.setFont(parent.getFont());
        }

        public int getNumberOfControls() {
            return 2;
        }

        private Combo getComboBoxControl(Composite parent) {
            if (this.fCombo == null) {
                this.fCombo = new Combo(parent, 8);
                this.fCombo.setFont(parent.getFont());
                int i = 0;
                while (i < this.fValues.size()) {
                    this.fCombo.add(this.fValues.get(i).getLabel(), i);
                    ++i;
                }
                this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        LabelingScheme oldValue = fValue;
                        String name = fCombo.getText();
                        fValue = this.getValueForName(name);
                        this.setPresentsDefaultValue(false);
                        this.fireValueChanged("field_editor_value", (Object)oldValue, (Object)fValue);
                    }
                });
            }
            return this.fCombo;
        }

        private LabelingScheme getValueForName(String name) {
            int i = 0;
            while (i < this.fValues.size()) {
                LabelingScheme scheme = this.fValues.get(i);
                if (scheme.getLabel().equals(name)) {
                    return scheme;
                }
                ++i;
            }
            return this.fValues.get(0);
        }

        private void updateComboForValue(LabelingScheme value) {
            this.fValue = value;
            int i = 0;
            while (i < this.fValues.size()) {
                if (value.equals((Object)this.fValues.get(i))) {
                    this.fCombo.setText(value.getLabel());
                    return;
                }
                ++i;
            }
            if (this.fValues.size() > 0) {
                this.fValue = this.fValues.get(0);
                this.fCombo.setText(this.fValue.getLabel());
            }
        }

        public void setEnabled(boolean enabled, Composite parent) {
            super.setEnabled(enabled, parent);
            this.getComboBoxControl(parent).setEnabled(enabled);
        }

        protected void doLoad() {
            this.updateComboForValue(this.fOriginalValue);
        }

        protected void doLoadDefault() {
            this.updateComboForValue(this.fDefaultValue);
        }

        protected void doStore() {
            if (this.fValue == null) {
                this.fOriginalValue = this.fDefaultValue;
                DiagramFlagPreferences.setProjectFlagLabelingScheme((Resource)this.fDefaultValue.getResource());
                return;
            }
            this.fOriginalValue = this.fValue;
            DiagramFlagPreferences.setProjectFlagLabelingScheme((Resource)this.fValue.getResource());
        }
    }
}

