/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.ui.IMemento;
import org.simantics.utils.ui.workbench.StringMemento;

public class Preferences {
    public static final String DIAGRAM_EXPORT_PDF_PATH = "diagram.export.pdf.path";
    public static final String DIAGRAM_EXPORT_PDF_ZOOM_TO_FIT = "diagram.export.pdf.zoomToFit";
    public static final String DIAGRAM_EXPORT_PDF_ATTACH_TG = "diagram.export.pdf.attachTG";
    public static final String DIAGRAM_EXPORT_PDF_INCLUDE_DIAGRAMS = "diagram.export.pdf.includeDiagrams";
    public static final String DIAGRAM_EXPORT_PDF_INCLUDE_DOCUMENTATION = "diagram.export.pdf.includeDoc";
    public static final String DIAGRAM_EXPORT_PDF_INCLUDE_COMPONENT_LEVEL_DOCUMENTATION = "diagram.export.pdf.includeComponentLevelDoc";
    public static final String DIAGRAM_EXPORT_PDF_ADD_PAGE_NUMBERS = "diagram.export.pdf.addPageNumbers";
    private static final String TAG_PATH = "path";
    private static final String ATTR_NAME = "name";

    public static Deque<String> decodePaths(String recentPathsPref) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            StringMemento sm = new StringMemento(recentPathsPref);
            IMemento[] iMementoArray = sm.getChildren(TAG_PATH);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                String name = m.getString(ATTR_NAME);
                if (name != null && !name.isEmpty()) {
                    result.add(name);
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return result;
    }

    public static String encodePaths(Deque<String> recentPaths) {
        StringMemento sm = new StringMemento();
        for (String path : recentPaths) {
            IMemento m = sm.createChild(TAG_PATH);
            m.putString(ATTR_NAME, path);
        }
        return sm.toString();
    }

    public static Deque<String> addFirstRemovingDuplicates(Deque<String> deque, String add, int truncateToMaxItems) {
        deque.addFirst(add);
        HashSet<String> dups = new HashSet<String>();
        Iterator<String> it = deque.iterator();
        while (it.hasNext()) {
            String path = it.next();
            if (dups.add(path)) continue;
            it.remove();
        }
        while (deque.size() > truncateToMaxItems) {
            deque.pollLast();
        }
        return deque;
    }
}

