/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser2.contributions;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural.stubs.StructuralResource2;

public enum IsUserDefinedComponentTest implements Test
{
    INSTANCE;


    public static IsUserDefinedComponentTest get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return Variable.class.equals(contentType) || Resource.class.equals(contentType);
    }

    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
        if (content instanceof Variable) {
            Variable v = (Variable)content;
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource type = v.getPossibleType(graph, STR.Component);
            return IsUserDefinedComponentTest.isUserComponentType(graph, type, STR);
        }
        if (content instanceof Resource) {
            Resource r = (Resource)content;
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource type = graph.getPossibleType(r, STR.Component);
            return IsUserDefinedComponentTest.isUserComponentType(graph, type, STR);
        }
        return false;
    }

    private static boolean isUserComponentType(ReadGraph graph, Resource type, StructuralResource2 STR) throws DatabaseException {
        if (type == null) {
            return false;
        }
        Resource definedBy = graph.getPossibleObject(type, STR.IsDefinedBy);
        if (definedBy != null) {
            return true;
        }
        boolean procedural = graph.isInstanceOf(type, STR.ProceduralComponentType);
        return procedural;
    }
}

