/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.handlers;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.commandlog.CutCommand;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardCutHandler
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardCutHandler.class);
    private static IStatusLineManager status;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        status = WorkbenchUtils.getStatusLine((IWorkbenchSite)HandlerUtil.getActiveSite((ExecutionEvent)event));
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        final Resource[] rs = ResourceAdaptionUtils.toResources((Object)selection);
        if (rs == null) {
            StandardCutHandler.setStatus("Nothing to cut.");
            return null;
        }
        if (Commands.isRecording()) {
            Commands.record((Command)new CutCommand(rs));
        }
        Job job = new Job("Cut resources"){

            protected IStatus run(final IProgressMonitor monitor) {
                monitor.beginTask("Cut resources", rs.length);
                try {
                    final SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
                    Simantics.getSession().syncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            HashSet<Resource> unique = new HashSet<Resource>();
                            Resource[] resourceArray = rs;
                            int n = rs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Resource r = resourceArray[n2];
                                if (unique.add(r)) {
                                    CopyHandler handler = (CopyHandler)graph.adapt(r, CopyHandler.class);
                                    handler.cutToClipboard(graph, (SimanticsClipboardBuilder)builder, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                                }
                                ++n2;
                            }
                        }
                    });
                    Simantics.setClipboard((SimanticsClipboard)builder);
                    StandardCutHandler.setCutMessage(builder.getContents().size(), "resource");
                    return Status.OK_STATUS;
                }
                catch (DatabaseException e) {
                    LOGGER.error("Cut operation failed", (Throwable)e);
                    return new Status(4, "org.simantics.modeling.ui", "Cut operation failed", (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private static void setCutMessage(int count, String elementName) {
        if (count > 1) {
            StandardCutHandler.setStatus("Cut " + count + " " + elementName + "s to clipboard");
        } else if (count == 1) {
            StandardCutHandler.setStatus("Cut " + elementName + " to clipboard");
        } else {
            StandardCutHandler.setStatus("Nothing to cut.");
        }
    }

    private static void setStatus(String message) {
        if (status != null) {
            SWTUtils.asyncExec((Display)PlatformUI.getWorkbench().getDisplay(), () -> status.setMessage(message));
        }
    }

    public static String cutResourcesToClipboard(final Resource[] rs, ISelection selection) {
        try {
            final SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Resource[] resourceArray = rs;
                    int n = rs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource r = resourceArray[n2];
                        CopyHandler handler = (CopyHandler)graph.adapt(r, CopyHandler.class);
                        handler.cutToClipboard(graph, (SimanticsClipboardBuilder)builder, null);
                        ++n2;
                    }
                }
            });
            Simantics.setClipboard((SimanticsClipboard)builder);
            StandardCutHandler.setCutMessage(builder.getContents().size(), "resource");
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to cut {} resources to clipboard: {}", new Object[]{rs.length, Arrays.toString(rs), e});
        }
        return null;
    }
}

