/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.modeling.help.HelpContexts;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualHelp
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextualHelp.class);

    private static String getPossibleId(ExecutionEvent event) {
        Variable variable;
        Resource resource;
        ISelection sel;
        block3: {
            try {
                sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                resource = WorkbenchSelectionUtils.getPossibleResource((Object)sel);
                variable = WorkbenchSelectionUtils.getPossibleVariable((Object)sel);
                if (!sel.isEmpty() || resource != null || variable != null) break block3;
                return null;
            }
            catch (DatabaseException e) {
                LOGGER.error("", (Throwable)e);
                return null;
            }
        }
        return (String)Simantics.getSession().syncRequest((Read)new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                return HelpContexts.getPossibleId((ReadGraph)graph, (Resource)resource, (Variable)variable, (Object)sel);
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String id = ContextualHelp.getPossibleId(event);
        if (id != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(id);
        }
        return null;
    }

    @Deprecated
    public static String getPossibleId(ReadGraph graph, Resource resource, Variable variable, ISelection sel) throws DatabaseException {
        return HelpContexts.getPossibleId((ReadGraph)graph, (Resource)resource, (Variable)variable, (Object)sel);
    }
}

