/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.function;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.modeling.ui.function.StandardPersistor;
import org.simantics.modeling.ui.typicals.NewTypicalDiagramInstance;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.ui.workbench.action.DefaultActions;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class All {
    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable singleVariableSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Resource")
    public static Resource projectSelection(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return Simantics.getProjectResource();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> StatePersistor")
    public static StatePersistor standardPersistor(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        String configurationId = (String)context.getParent(graph).getPossiblePropertyValue(graph, "browseContext");
        return new StandardPersistor(configurationId);
    }

    @SCLValue(type="Resource -> Resource -> Resource")
    public static Resource standardTypicalInstantiator(Resource model, Resource target) throws DatabaseException {
        Session session = Simantics.getSession();
        Collection typicals = TypicalUtil.findModelTypicals((RequestProcessor)session, (Resource)model);
        if (typicals.isEmpty()) {
            ShowMessage.showInformation((String)"No Typical Diagrams", (String)"There are no typical diagrams in the selected model. Cannot instantiate.");
            return null;
        }
        List namedTypicals = TypicalUtil.toNamedResources((RequestProcessor)session, (Collection)typicals);
        return (Resource)TypicalUtil.syncExec(procedure -> NewTypicalDiagramInstance.asyncQueryFromList(namedTypicals, selectedTypical -> {
            try {
                try {
                    if (selectedTypical != null) {
                        session.syncRequest(TypicalUtil.instantiateTemplate((Resource)target, (NamedResource)selectedTypical, instance -> {
                            try {
                                HashSet customlyNamed = new HashSet();
                                TypicalUtil.applyTypicalModuleNames((WriteGraph)((WriteGraph)instance.first), (Resource)((Resource)instance.second), customlyNamed);
                                procedure.execute((Object)((Resource)instance.second));
                                DefaultActions.asyncPerformDefaultAction((Session)session, (Object)instance.second, (boolean)false, (boolean)false, (boolean)true);
                            }
                            catch (DatabaseException e) {
                                procedure.exception((Throwable)e);
                            }
                        }));
                    }
                }
                catch (Throwable e) {
                    procedure.exception(e);
                    procedure.execute(null);
                }
            }
            finally {
                procedure.execute(null);
            }
        }));
    }
}

