/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.documents;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenMappedDocumentAdapter
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.document.ui.editor";

    public OpenMappedDocumentAdapter() throws MalformedURLException {
        super("Document Editor", ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.famfamfam.silk/icons/table.png")));
    }

    public String getEditorId() {
        return EDITOR_ID;
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        return g.isInstanceOf(r, DiagramResource.getInstance((ReadGraph)g).Element);
    }

    public void openEditor(final Resource element) throws Exception {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                final Resource component = graph.getPossibleObject(element, ModelingResources.getInstance((ReadGraph)graph).ElementToComponent);
                if (component == null) {
                    return;
                }
                Variable variable = (Variable)graph.adapt(component, Variable.class);
                final Resource model = Variables.getModel((ReadGraph)graph, (Variable)variable);
                final RVI rvi = variable.getRVI(graph);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String editorId = OpenMappedDocumentAdapter.this.getEditorId();
                            if (rvi != null) {
                                WorkbenchUtils.openEditor((String)editorId, (IEditorInput)new ResourceEditorInput2(editorId, component, model, rvi));
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }
}

