/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers.e4;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.utils.operations.IOperation;
import org.simantics.modeling.ModelingOperationConstants;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.actions.NavigateToTarget;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.e4.E4WorkbenchUtils;
import org.simantics.utils.datastructures.persistent.ContextMap;
import org.simantics.utils.datastructures.persistent.IContextMap;
import org.simantics.utils.ui.ErrorLogger;

public class StructuralBrowsingHandler
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    Selection selection;
    MPart part;
    ISessionContext sessionContext;
    IResourceEditorInput2 input;

    public StructuralBrowsingHandler(ISessionContext sessionContext, MPart part, IResourceEditorInput2 input) {
        this.sessionContext = sessionContext;
        this.part = part;
        this.input = input;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleDoubleClick(MouseEvent.MouseDoubleClickedEvent me) {
        if (this.sessionContext == null || this.diagram == null) {
            return false;
        }
        Set sel = this.selection.getSelection(0);
        if (sel.size() == 1) {
            IElement e = (IElement)sel.iterator().next();
            Object data = e.getHint(ElementHints.KEY_OBJECT);
            final Resource runtime = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
            if (data instanceof Resource) {
                final Resource element = (Resource)data;
                final int stateMask = me.stateMask;
                try {
                    return (Boolean)this.sessionContext.getSession().syncRequest((Read)new UniqueRead<Boolean>(){

                        public Boolean perform(ReadGraph graph) throws DatabaseException {
                            return StructuralBrowsingHandler.this.browse(graph, element, runtime, stateMask);
                        }
                    });
                }
                catch (DatabaseException e1) {
                    ErrorLogger.defaultLogError((Throwable)e1);
                }
            }
        }
        return false;
    }

    private boolean browse(ReadGraph graph, Resource element, Resource runtimeDiagram, int stateMask) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, dr.Flag)) {
            ContextMap parameters = new ContextMap();
            parameters.put(ModelingOperationConstants.WORKBENCH_WINDOW, this.part.getContext().get(MWindow.class));
            parameters.put(ModelingOperationConstants.WORKBENCH_PART, (Object)this.part);
            parameters.put(IOperation.SUBJECT, (Object)element);
            new NavigateToTarget().exec(graph.getSession(), (IContextMap)parameters);
            return FlagUtil.isJoined((ReadGraph)graph, (Resource)element);
        }
        if ((stateMask & 0x40) == 0) {
            return false;
        }
        if (runtimeDiagram == null || !graph.isInstanceOf(runtimeDiagram, DIA.RuntimeDiagram)) {
            return false;
        }
        Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
        if (component == null) {
            return false;
        }
        Resource type = graph.getPossibleType(component, sr.Component);
        if (type == null) {
            return false;
        }
        if (graph.hasStatement(type, sr.ComponentType_Locked)) {
            return false;
        }
        Resource definedBy = graph.getPossibleObject(type, sr.IsDefinedBy);
        if (definedBy == null) {
            return false;
        }
        Resource diagram = graph.getPossibleObject(definedBy, mr.CompositeToDiagram);
        if (diagram == null) {
            return false;
        }
        Resource model = this.input.getModel(graph);
        RVI subprocessRVI = null;
        String rvis = (String)graph.getPossibleRelatedValue(runtimeDiagram, DIA.RuntimeDiagram_HasRVI);
        if (rvis != null) {
            RVI rvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)rvis);
            Variable base = Variables.getConfigurationContext((ReadGraph)graph, (Resource)model);
            Variable current = rvi.resolve(graph, base);
            Variable subprocess = current.browse(graph, component);
            subprocessRVI = subprocess.getRVI(graph);
        } else {
            model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(definedBy));
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(this.navigateToSubstructure(diagram, model, subprocessRVI));
        return true;
    }

    private Runnable navigateToSubstructure(final Resource diagram, final Resource model, final RVI subprocessRVI) {
        return new Runnable(){

            @Override
            public void run() {
                String inputId = Long.toString(diagram.getResourceId());
                HashMap<String, Object> inputMap = new HashMap<String, Object>();
                inputMap.put("keyResource", diagram);
                inputMap.put("keyModel", model);
                inputMap.put("keyRVI", subprocessRVI);
                E4WorkbenchUtils.openEditor((String)StructuralBrowsingHandler.this.part.getElementId(), (String)"", (String)"", (String)inputId, inputMap);
            }
        };
    }
}

