/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.structural.stubs.StructuralResource2;

public class HeadlessStructuralBrowsingHandler
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    Selection selection;
    ISessionContext sessionContext;
    ResourceArray parentStructuralPath;
    IDiagramUpdateSupport diagramProvider;

    public HeadlessStructuralBrowsingHandler(IDiagramUpdateSupport diagramProvider, ISessionContext sessionContext, ResourceArray parentStructuralPath) {
        assert (diagramProvider != null);
        this.diagramProvider = diagramProvider;
        this.sessionContext = sessionContext;
        this.parentStructuralPath = parentStructuralPath;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleDoubleClick(MouseEvent.MouseDoubleClickedEvent me) {
        if (this.sessionContext == null) {
            return false;
        }
        Set sel = this.selection.getSelection(0);
        if (sel.size() == 1) {
            IElement e = (IElement)sel.iterator().next();
            Object data = e.getHint(ElementHints.KEY_OBJECT);
            if (data instanceof Resource) {
                final Resource element = (Resource)data;
                this.sessionContext.getSession().asyncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
                        if (graph.isInstanceOf(element, dr.Flag)) {
                            return;
                        }
                        Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
                        if (component == null) {
                            return;
                        }
                        Resource type = graph.getSingleType(component, sr.Component);
                        if (type == null) {
                            return;
                        }
                        Resource definedBy = graph.getPossibleObject(type, sr.IsDefinedBy);
                        if (definedBy == null) {
                            return;
                        }
                        Resource diagram = graph.getPossibleObject(definedBy, mr.CompositeToDiagram);
                        if (diagram == null) {
                            return;
                        }
                        HeadlessStructuralBrowsingHandler.this.diagramProvider.updateDiagram(HeadlessStructuralBrowsingHandler.this.parentStructuralPath.prepended(new Resource[]{diagram, component}));
                    }
                });
            }
            return true;
        }
        return false;
    }

    public static interface IDiagramUpdateSupport {
        public void updateDiagram(ResourceArray var1);
    }
}

