/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.dnd;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.request.IsLinkedTo;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.commandlog.CommandRecording;
import org.simantics.modeling.ui.diagramEditor.dnd.DropSuggestion;
import org.simantics.modeling.ui.diagramEditor.dnd.MarkupDialog;
import org.simantics.modeling.ui.diagramEditor.dnd.Messages;

public class DropSuggestions {
    public static boolean askSuggestions(Shell parent, List<DropSuggestion> suggestions) {
        return MarkupDialog.open(parent, "diagram.dropSuggestionDialog", Messages.DropSuggestions_ApplySuggestions_DialogTitle, Messages.DropSuggestions_ApplySuggestions_DialogMsg, DropSuggestions.formatSuggestions(suggestions), 4, 0, 2624) == 0;
    }

    private static String formatSuggestions(List<DropSuggestion> suggestions) {
        return suggestions.stream().map(DropSuggestion::toString).collect(Collectors.joining("\n", "- ", ""));
    }

    public static Write performSuggestionsRequest(List<DropSuggestion> suggestions) {
        return graph -> {
            for (DropSuggestion s : suggestions) {
                s.fix(graph);
            }
        };
    }

    public static DropSuggestion linkToLibrary(ReadGraph graph, Resource linkSource, Resource linkTarget) throws DatabaseException {
        return new LinkToLibrary(NLS.bind((String)Messages.DropSuggestions_Description_LinkToLibrary, (Object)NameLabelUtil.modalName((ReadGraph)graph, (Resource)linkSource, (NameLabelMode)NameLabelMode.NAME_AND_LABEL), (Object)NameLabelUtil.modalName((ReadGraph)graph, (Resource)linkTarget, (NameLabelMode)NameLabelMode.NAME_AND_LABEL)), linkSource, linkTarget);
    }

    public static class LinkToLibrary
    implements DropSuggestion {
        private final String desc;
        private final Resource linkFrom;
        private final Resource linkTo;

        public LinkToLibrary(String desc, Resource linkFrom, Resource linkTo) {
            this.desc = desc;
            this.linkFrom = linkFrom;
            this.linkTo = linkTo;
        }

        @Override
        public void fix(WriteGraph graph) throws DatabaseException {
            if (((Boolean)graph.syncRequest((Read)new IsLinkedTo(this.linkFrom, this.linkTo))).booleanValue()) {
                throw new ValidationException(NLS.bind((String)Messages.DropSuggestions_Problem_CyclicDependency, (Object)NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)this.linkTo), (Object)NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)this.linkFrom)));
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            graph.claim(this.linkFrom, L0.IsLinkedTo, L0.IsLinkedTo_Inverse, this.linkTo);
            CommandRecording.recordLinkSharedOntology((ReadGraph)graph, (Resource)this.linkFrom, (Resource)this.linkTo);
        }

        @Override
        public String toString() {
            return this.desc;
        }
    }
}

