/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.diagramEditor.EditorState;

public class DiagramEditorStates {
    public static EditorState toEditorState(ICanvasContext ctx) {
        return DiagramEditorStates.toEditorState(ctx, true, true, true);
    }

    public static EditorState toEditorState(ICanvasContext ctx, boolean saveTransform, boolean saveSelection, boolean saveToolMode) {
        IToolMode toolMode;
        EditorState state = new EditorState();
        if (saveTransform) {
            state.viewTransform = (AffineTransform)ctx.getHintStack().getHint(Hints.KEY_CANVAS_TRANSFORM);
            if (state.viewTransform != null && state.viewTransform.getDeterminant() == 0.0) {
                state.viewTransform = null;
            }
        }
        if (saveToolMode && (toolMode = (IToolMode)ctx.getHintStack().getHint(Hints.KEY_TOOL)) != null) {
            state.toolMode = toolMode.getId();
        }
        if (saveSelection) {
            Set selection = Collections.emptySet();
            for (Selection s : ctx.getItemsByClass(Selection.class)) {
                selection = s.getSelection(0);
            }
            state.selection = DiagramEditorStates.toResources(selection);
        }
        return state;
    }

    public static void saveEditorState(String virtualGraph, Resource diagram, ICanvasContext ctx, ListenerSupport support) {
        DiagramEditorStates.saveEditorState(virtualGraph, diagram, DiagramEditorStates.toEditorState(ctx), support);
    }

    public static Set<Resource> toResources(Set<IElement> elements) {
        HashSet<Resource> result = new HashSet<Resource>();
        for (IElement e : elements) {
            Object obj = ElementUtils.getObject((IElement)e);
            if (!(obj instanceof Resource)) continue;
            result.add((Resource)obj);
        }
        return result;
    }

    public static Set<IElement> toElements(Set<Resource> selection, IDiagram diagram) {
        HashSet<IElement> result = new HashSet<IElement>();
        DataElementMap dem = (DataElementMap)diagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
        for (Resource selected : selection) {
            IElement e = dem.getElement(diagram, (Object)selected);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    public static void saveEditorState(String virtualGraph, final Resource diagram, final EditorState editorState, ListenerSupport support) {
        Session session = Simantics.getSession();
        final VirtualGraph vg = virtualGraph == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(virtualGraph);
        session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                if (Layer0Utils.isContainerPublished((ReadGraph)graph, (Resource)diagram)) {
                    return;
                }
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                for (Resource state : graph.getObjects(diagram, DIA.HasEditorState)) {
                    RemoverUtil.remove((WriteGraph)graph, (Resource)state);
                }
                graph.syncRequest((Write)new WriteRequest(vg){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        DiagramEditorStates.newEditorState(graph, diagram, editorState);
                    }
                });
            }
        }, e -> {
            if (e != null) {
                support.exception((Throwable)e);
            }
        });
    }

    private static Resource newEditorState(WriteGraph graph, Resource stateOf, EditorState editorState) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource state = graph.newResource();
        graph.claim(state, L0.InstanceOf, null, DIA.EditorState);
        graph.claim(stateOf, DIA.HasEditorState, state);
        if (editorState.viewTransform != null) {
            double[] matrix = new double[6];
            editorState.viewTransform.getMatrix(matrix);
            graph.claimLiteral(state, DIA.EditorState_ViewTransform, G2D.Transform, (Object)matrix, (Binding)Bindings.DOUBLE_ARRAY);
        }
        if (editorState.toolMode != null) {
            graph.claimLiteral(state, DIA.EditorState_ToolMode, L0.String, (Object)editorState.toolMode, (Binding)Bindings.STRING);
        }
        for (Resource selected : editorState.selection) {
            graph.claim(state, DIA.EditorState_Selection, null, selected);
        }
        return state;
    }

    public static EditorState readEditorState(final Resource source) throws DatabaseException {
        return (EditorState)Simantics.getSession().syncRequest((Read)new ResourceRead<EditorState>(source){

            public EditorState perform(ReadGraph graph) throws DatabaseException {
                EditorState state = new EditorState();
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                Iterator iterator = graph.getObjects(source, DIA.HasEditorState).iterator();
                if (iterator.hasNext()) {
                    Resource editorState = (Resource)iterator.next();
                    state.viewTransform = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)editorState, (Resource)DIA.EditorState_ViewTransform, (boolean)false);
                    state.toolMode = (String)graph.getPossibleRelatedValue(editorState, DIA.EditorState_ToolMode, (Binding)Bindings.STRING);
                    state.selection = new HashSet<Resource>();
                    for (Resource selected : graph.getObjects(editorState, DIA.EditorState_Selection)) {
                        if (!graph.isInstanceOf(selected, DIA.Element)) continue;
                        state.selection.add(selected);
                    }
                }
                return state;
            }
        });
    }
}

