/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.style;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.handler.Paster;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.structural.stubs.StructuralResource2;

public class DecorationStyles {
    private static final Class[] IGNORED_NODES_FOR_POSITION = new Class[]{Decoration.class, TextNode.class};

    public static Object getStyleIdentifier(ReadGraph graph, Resource runtimeDiagram, Resource element) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(element, DIA.RouteGraphConnection)) {
            Collection connectors = graph.getObjects(element, DIA.HasConnector);
            Collection routeNodes = graph.getObjects(element, DIA.HasInteriorRouteNode);
            HashSet<AffineTransform> identifier = new HashSet<AffineTransform>(connectors.size() + routeNodes.size());
            for (Resource connector : connectors) {
                for (Resource connectedTo : graph.getObjects(connector, STR.Connects)) {
                    if (connectedTo.equals(element)) continue;
                    AffineTransform at = DiagramGraphUtil.getDynamicAffineTransform((ReadGraph)graph, (Resource)runtimeDiagram, (Resource)connectedTo, (Resource)DIA.HasDynamicTransform, (boolean)false);
                    identifier.add(at);
                }
            }
            for (Resource routeLine : routeNodes) {
                Paster.RouteLine rl = Paster.readRouteLine((ReadGraph)graph, (Resource)routeLine);
                identifier.add((AffineTransform)rl);
            }
            return identifier;
        }
        return DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
    }

    /*
     * WARNING - void declaration
     */
    public static AffineTransform getDecorationPosition(INode node, Function<Rectangle2D, AffineTransform> fromBoundsFunction, Point2D connectionOffset) {
        Rectangle2D bounds = NodeUtil.getLocalBounds((INode)node, (Class[])IGNORED_NODES_FOR_POSITION);
        if (bounds == null) {
            return AffineTransform.getTranslateInstance(0.0, 0.0);
        }
        INode iNode = node;
        if (iNode instanceof ConnectionNode) {
            void cn;
            ConnectionNode connectionNode = (ConnectionNode)iNode;
            ConnectionNode cfr_ignored_0 = (ConnectionNode)iNode;
            IG2DNode[] iG2DNodeArray = cn.getSortedNodes();
            int n = iG2DNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RouteGraphNode rgn;
                RouteGraph rg;
                Point2D nearest;
                IG2DNode child = iG2DNodeArray[n2];
                if (child instanceof RouteGraphNode && (nearest = (rg = (rgn = (RouteGraphNode)child).getRouteGraph()).findNearestPoint(bounds.getCenterX(), bounds.getCenterY())) != null) {
                    double ox = 0.0;
                    double oy = 0.0;
                    if (connectionOffset != null) {
                        ox = connectionOffset.getX();
                        oy = connectionOffset.getY();
                    }
                    return AffineTransform.getTranslateInstance(nearest.getX() + ox, nearest.getY() + oy);
                }
                ++n2;
            }
        }
        return fromBoundsFunction.apply(bounds);
    }
}

