/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.db.Disposable;
import org.simantics.db.Resource;
import org.simantics.db.procedure.Listener;
import org.simantics.diagram.elements.MonitorClass;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.modeling.ui.diagram.monitor.MonitorVariableValue;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;

public class MonitorListener
implements Listener<MonitorVariableValue>,
Runnable,
Disposable {
    private final Resource element;
    private ICanvasContext canvas;
    private IDiagram diagram;
    private final Map<String, String> substitutions;
    private transient AtomicReference<MonitorVariableValue> lastScheduledUpdate = null;
    private transient AtomicBoolean inUpdate = null;

    public MonitorListener(Resource element, ICanvasContext canvas, IDiagram diagram, Map<String, String> substitutions) {
        if (element == null) {
            throw new NullPointerException("null element");
        }
        if (canvas == null) {
            throw new NullPointerException("null canvas");
        }
        if (diagram == null) {
            throw new NullPointerException("null diagram");
        }
        if (substitutions == null) {
            throw new NullPointerException("null substitutions");
        }
        this.element = element;
        this.canvas = canvas;
        this.diagram = diagram;
        this.substitutions = substitutions;
    }

    public void dispose() {
        this.canvas = null;
        this.diagram = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MonitorVariableValue result) {
        if (this.inUpdate == null) {
            this.inUpdate = new AtomicBoolean(false);
        }
        if (this.lastScheduledUpdate == null) {
            this.lastScheduledUpdate = new AtomicReference();
        }
        this.lastScheduledUpdate.set(result);
        AtomicBoolean atomicBoolean = this.inUpdate;
        synchronized (atomicBoolean) {
            if (!this.inUpdate.compareAndSet(false, true)) {
                return;
            }
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isDisposed()) {
            return;
        }
        IElement el = ElementUtils.getByData((IDiagram)this.diagram, (Object)this.element);
        if (el == null) {
            return;
        }
        try {
            this.performUpdate(el);
        }
        catch (Throwable throwable) {
            AtomicBoolean atomicBoolean = this.inUpdate;
            synchronized (atomicBoolean) {
                if (this.lastScheduledUpdate.get() != null) {
                    this.scheduleUpdate();
                } else {
                    this.inUpdate.set(false);
                }
            }
            throw throwable;
        }
        AtomicBoolean atomicBoolean = this.inUpdate;
        synchronized (atomicBoolean) {
            if (this.lastScheduledUpdate.get() != null) {
                this.scheduleUpdate();
            } else {
                this.inUpdate.set(false);
            }
        }
    }

    private void scheduleUpdate() {
        ICanvasContext canvas = this.canvas;
        if (!this.isDisposed()) {
            ThreadUtils.asyncExec((IThreadWorkQueue)canvas.getThreadAccess(), (Runnable)this);
        }
    }

    private void performUpdate(IElement el) {
        MonitorVariableValue result = this.lastScheduledUpdate.getAndSet(null);
        String value = "<no variable>";
        if (result != null) {
            value = result.getValue() != null ? result.getValue() : "<no value>";
            el.setHint(MonitorClass.KEY_MONITOR_COMPONENT, (Object)result.getMonitorVariable().getMonitorComponent());
            ElementUtils.setOrRemoveHint((IHintContext)el, (IHintContext.Key)MonitorClass.KEY_MONITOR_IS_EXTERNAL, (Object)result.getMonitorVariable().isExternal());
        } else {
            el.removeHint(MonitorClass.KEY_MONITOR_COMPONENT);
            el.removeHint(MonitorClass.KEY_MONITOR_IS_EXTERNAL);
        }
        this.substitutions.put("#v1", value);
        Map subs = (Map)el.getHint(MonitorClass.KEY_MONITOR_SUBSTITUTIONS);
        if (this.substitutions != subs) {
            el.setHint(MonitorClass.KEY_MONITOR_SUBSTITUTIONS, this.substitutions);
        }
        el.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DELAYED_UPDATE);
    }

    public void exception(Throwable t) {
        ErrorLogger.defaultLogError((Throwable)t);
    }

    public boolean isDisposed() {
        return this.canvas == null || this.diagram == null || this.canvas.isDisposed();
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonitorListener other = (MonitorListener)obj;
        return this.element.equals(other.element);
    }
}

