/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.monitor;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.osgi.framework.Bundle;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.Combo;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.diagram.monitor.AvailableFontFactory;
import org.simantics.modeling.ui.diagram.monitor.AvailableFontSizeFactory;
import org.simantics.modeling.ui.diagram.monitor.AvailableFormatFactory;
import org.simantics.modeling.ui.diagram.monitor.AvailableTemplateFactory;
import org.simantics.modeling.ui.diagram.monitor.CurrentFontFactory;
import org.simantics.modeling.ui.diagram.monitor.CurrentFontSizeFactory;
import org.simantics.modeling.ui.diagram.monitor.CurrentFormatFactory;
import org.simantics.modeling.ui.diagram.monitor.CurrentTemplateFactory;
import org.simantics.modeling.ui.diagram.monitor.FontModifier;
import org.simantics.modeling.ui.diagram.monitor.FontSizeModifier;
import org.simantics.modeling.ui.diagram.monitor.FormatModifier;
import org.simantics.modeling.ui.diagram.monitor.Messages;
import org.simantics.modeling.ui.diagram.monitor.TemplateModifier;
import org.simantics.operation.Layer0X;
import org.simantics.selectionview.ConfigurationComposite;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.ui.BundleUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.gfx.ColorImageDescriptor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class MonitorComposite
extends ConfigurationComposite {
    private static final String DATA_CURRENT_COLOR = "COLOR";

    public void create(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        Display display = body.getDisplay();
        body.setBackground(display.getSystemColor(1));
        Composite buttonComposite = new Composite(body, 0);
        buttonComposite.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(4).extendedMargins(5, 5, 5, 5).applyTo(buttonComposite);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)buttonComposite);
        support.setParameter("resourceManager", (Object)resourceManager);
        Label templateHeader = new Label(buttonComposite, support, 0);
        templateHeader.setText(Messages.MonitorComposite_Template);
        templateHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)templateHeader.getWidget());
        Combo templateCombo = new Combo(buttonComposite, support, 8);
        templateCombo.setItemFactory((ReadFactory)new AvailableTemplateFactory());
        templateCombo.setSelectionFactory((ReadFactory)new CurrentTemplateFactory());
        templateCombo.addModifyListener((ModifyListener)new TemplateModifier());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)templateCombo.getWidget());
        Button setDefaultButton = new Button(buttonComposite, support, 8);
        setDefaultButton.setText(Messages.MonitorComposite_SetAsDefault);
        setDefaultButton.setTooltipText(Messages.MonitorComposite_SetAsDefaultForNewlyCreatedMonitors);
        setDefaultButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource monitor) throws DatabaseException {
                graph.markUndoPoint();
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(monitor));
                Resource currentTemplate = graph.getPossibleObject(monitor, L0X.ObtainsProperty);
                if (root != null && !graph.isImmutable(root) && currentTemplate != null) {
                    graph.deny(root, DIA.HasDefaultMonitorTemplate);
                    graph.claim(root, DIA.HasDefaultMonitorTemplate, currentTemplate);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)setDefaultButton.getWidget());
        Button resetButton = new Button(buttonComposite, support, 8);
        resetButton.setText(Messages.MonitorComposite_ResetLocalChanges);
        resetButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource monitor) throws DatabaseException {
                graph.markUndoPoint();
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                if (graph.hasStatement(monitor, DIA.HasFont)) {
                    graph.deny(monitor, DIA.HasFont);
                }
                if (graph.hasStatement(monitor, DIA.HasFormatter)) {
                    graph.deny(monitor, DIA.HasFormatter);
                }
                if (graph.hasStatement(monitor, DIA.HasColor)) {
                    graph.deny(monitor, DIA.HasColor);
                }
                if (graph.hasStatement(monitor, L0X.HasExpression)) {
                    graph.deny(monitor, L0X.HasExpression);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)resetButton.getWidget());
        Label fontHeader = new Label(buttonComposite, support, 0);
        fontHeader.setText(Messages.MonitorComposite_FontFamily);
        fontHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)fontHeader.getWidget());
        Combo fontCombo = new Combo(buttonComposite, support, 8);
        fontCombo.setItemFactory2((ReadFactory)new AvailableFontFactory());
        fontCombo.setSelectionFactory((ReadFactory)new CurrentFontFactory());
        fontCombo.addModifyListener((ModifyListener)new FontModifier());
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)fontCombo.getWidget());
        Label sizeHeader = new Label(buttonComposite, support, 0);
        sizeHeader.setText(Messages.MonitorComposite_FontSize);
        sizeHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)sizeHeader.getWidget());
        Combo sizeCombo = new Combo(buttonComposite, support, 8);
        sizeCombo.setItemFactory2((ReadFactory)new AvailableFontSizeFactory());
        sizeCombo.setSelectionFactory((ReadFactory)new CurrentFontSizeFactory());
        sizeCombo.addModifyListener((ModifyListener)new FontSizeModifier());
        GridDataFactory.fillDefaults().grab(false, false).span(3, 1).minSize(50, 0).applyTo((Control)sizeCombo.getWidget());
        Label formatterHeader = new Label(buttonComposite, support, 0);
        formatterHeader.setText(Messages.MonitorComposite_Formatting);
        formatterHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)formatterHeader.getWidget());
        Combo formatCombo = new Combo(buttonComposite, support, 8);
        formatCombo.setItemFactory((ReadFactory)new AvailableFormatFactory());
        formatCombo.setSelectionFactory((ReadFactory)new CurrentFormatFactory());
        formatCombo.addModifyListener((ModifyListener)new FormatModifier());
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)formatCombo.getWidget());
        Composite rowComposite = new Composite(buttonComposite, 0);
        rowComposite.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)rowComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(4).extendedMargins(5, 5, 5, 5).applyTo(rowComposite);
        Label alignHeader = new Label(rowComposite, support, 0);
        alignHeader.setText(Messages.MonitorComposite_Alignment);
        alignHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)alignHeader.getWidget());
        Bundle iconBundle = Platform.getBundle((String)"com.famfamfam.silk");
        Composite alignComposite = new Composite(rowComposite, 0);
        alignComposite.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().span(1, 1).grab(false, false).applyTo((Control)alignComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(4).extendedMargins(5, 5, 5, 5).applyTo(alignComposite);
        Button leadButton = new Button(alignComposite, support, 2);
        leadButton.setTooltipText(Messages.MonitorComposite_LeftAlignment);
        leadButton.setImage((Image)resourceManager.get((DeviceResourceDescriptor)BundleUtils.getImageDescriptorFromBundle((Bundle)iconBundle, (String)"icons/text_align_left.png")));
        leadButton.setSelectionFactory((ReadFactory)new AlignmentSelectedFactory("http://www.simantics.org/G2D-1.1/Alignment/Leading"));
        leadButton.addSelectionListener((SelectionListener)new AlignmentSelectionListener(context, "http://www.simantics.org/G2D-1.1/Alignment/Leading"));
        Button centerButton = new Button(alignComposite, support, 2);
        centerButton.setTooltipText(Messages.MonitorComposite_CenterAlignment);
        centerButton.setImage((Image)resourceManager.get((DeviceResourceDescriptor)BundleUtils.getImageDescriptorFromBundle((Bundle)iconBundle, (String)"icons/text_align_center.png")));
        centerButton.setSelectionFactory((ReadFactory)new AlignmentSelectedFactory("http://www.simantics.org/G2D-1.1/Alignment/Center"));
        centerButton.addSelectionListener((SelectionListener)new AlignmentSelectionListener(context, "http://www.simantics.org/G2D-1.1/Alignment/Center"));
        Button trailButton = new Button(alignComposite, support, 2);
        trailButton.setTooltipText(Messages.MonitorComposite_RightAlignment);
        trailButton.setImage((Image)resourceManager.get((DeviceResourceDescriptor)BundleUtils.getImageDescriptorFromBundle((Bundle)iconBundle, (String)"icons/text_align_right.png")));
        trailButton.setSelectionFactory((ReadFactory)new AlignmentSelectedFactory("http://www.simantics.org/G2D-1.1/Alignment/Trailing"));
        trailButton.addSelectionListener((SelectionListener)new AlignmentSelectionListener(context, "http://www.simantics.org/G2D-1.1/Alignment/Trailing"));
        Label colorHeader = new Label(rowComposite, support, 0);
        colorHeader.setText(Messages.MonitorComposite_Color);
        colorHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().indent(20, 0).grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)colorHeader.getWidget());
        Button colorButton = new Button(rowComposite, support, 8);
        colorButton.setImageFactory((ReadFactory)new CurrentColorImageFactory((Control)colorButton.getWidget(), DATA_CURRENT_COLOR));
        GridDataFactory.fillDefaults().indent(0, 0).grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)colorButton.getWidget());
        StyleEditWidget colorWidget = new StyleEditWidget((Control)colorButton.getWidget());
        colorButton.addSelectionListener((SelectionListener)colorWidget);
        support.register((Widget)colorWidget);
    }

    private static void setColor(final Resource[] resources, final RGB rgb) {
        Color c = Colors.irgb((RGB)rgb);
        final double[] color = new double[]{c.getR(), c.getG(), c.getB()};
        try {
            Simantics.sync((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    Resource[] resourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource r = resourceArray[n2];
                        Resource realizedColor = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(r, DIA.HasColor, DIA.RealizedColor));
                        if (realizedColor == null) {
                            realizedColor = graph.newResource();
                            graph.claim(realizedColor, L0.InstanceOf, null, DIA.RealizedColor);
                            graph.claim(r, DIA.HasColor, realizedColor);
                        }
                        graph.claimLiteral(realizedColor, DIA.RealizedColor_HasRGB, L0.DoubleArray, (Object)color, (Binding)Bindings.DOUBLE_ARRAY);
                        ++n2;
                    }
                    CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                    graph.addMetadata((Metadata)cm.add("Set color to " + String.valueOf(rgb) + " for resources " + Arrays.toString(resources)));
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    static class AlignmentSelectedFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        private String alignmentURI;

        public AlignmentSelectedFactory(String alignmentURI) {
            this.alignmentURI = alignmentURI;
        }

        public Object getIdentity(Object inputContents) {
            return new Triple(inputContents, (Object)this.alignmentURI, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource monitor) throws DatabaseException {
            G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
            Resource expectedAlignment = graph.getResource(this.alignmentURI);
            Resource alignment = graph.getPossibleObject(monitor, G2D.HasHorizontalAlignment);
            return ObjectUtils.objectEquals((Object)expectedAlignment, (Object)alignment);
        }
    }

    static class AlignmentSelectionListener
    extends SelectionListenerImpl<Resource> {
        private String alignmentURI;

        public AlignmentSelectionListener(ISessionContext context, String alignmentURI) {
            super(context);
            this.alignmentURI = alignmentURI;
        }

        public void apply(WriteGraph graph, Resource monitor) throws DatabaseException {
            graph.markUndoPoint();
            G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
            Resource alignment = graph.getResource(this.alignmentURI);
            graph.deny(monitor, G2D.HasHorizontalAlignment);
            graph.claim(monitor, G2D.HasHorizontalAlignment, null, alignment);
        }
    }

    private static class CurrentColorImageFactory
    extends ReadFactoryImpl<Resource, ImageDescriptor> {
        Control control;
        String colorKey;

        public CurrentColorImageFactory(Control control, String colorKey) {
            this.control = control;
            this.colorKey = colorKey;
        }

        public ImageDescriptor perform(ReadGraph graph, Resource monitor) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            Color c = (Color)graph.getPossibleRelatedAdapter(monitor, DIA.HasColor, Color.class);
            if (c == null) {
                c = new RGB.Integer(0, 0, 0);
            }
            final Color color = c;
            if (this.control != null) {
                SWTUtils.asyncExec((org.eclipse.swt.widgets.Widget)this.control, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed()) {
                            control.setData(colorKey, (Object)color);
                        }
                    }
                });
            }
            RGB rgb = Colors.rgb((Color)color);
            return new ColorImageDescriptor(rgb.red, rgb.green, rgb.blue, 16, 16, false);
        }
    }

    static class StyleEditWidget
    implements Widget,
    SelectionListener {
        Control control;
        Object input;

        public StyleEditWidget(Control control) {
            this.control = control;
        }

        public void widgetSelected(SelectionEvent e) {
            Resource[] resources = ResourceAdaptionUtils.toResources((Object)this.input);
            if (resources.length != 0) {
                RGB rgb;
                ColorDialog dialog = new ColorDialog(WorkbenchUtils.getActiveWorkbenchWindowShell(), 0);
                dialog.setText(Messages.MonitorComposite_SetMonitorColor);
                Color oldColor = (Color)this.control.getData(MonitorComposite.DATA_CURRENT_COLOR);
                if (oldColor != null) {
                    RGB oldRgb = Colors.rgb((Color)oldColor);
                    dialog.setRGB(oldRgb);
                }
                if ((rgb = dialog.open()) != null) {
                    MonitorComposite.setColor(resources, rgb);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void setInput(ISessionContext context, Object input) {
            this.input = input;
        }
    }
}

