/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions.style;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.eclipse.osgi.util.NLS;
import org.simantics.modeling.ui.actions.style.Messages;
import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.strings.format.MetricsFormatList;
import org.simantics.utils.strings.format.MetricsFormatListListener;

public class MetricsEditor
extends JPanel {
    private static final long serialVersionUID = 3781280603509654789L;
    private JTextField valueTestField;
    private JTextField valuePresentationField;
    private JTextField formatNameField;
    private JTextField formatPatternField;
    private MetricsFormat format;
    private MetricsFormatList formatList;
    private double formatValue;
    private JTable formatTable;
    private MetricsTableModel tableModel;

    public MetricsEditor() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.valueTestField = new JTextField();
        this.valuePresentationField = new JTextField();
        this.formatNameField = new JTextField();
        this.formatPatternField = new JTextField();
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        JPanel fieldPanel = new JPanel(new GridLayout(0, 1));
        panel.add((Component)labelPanel, "West");
        panel.add((Component)fieldPanel, "Center");
        labelPanel.add(new JLabel(Messages.MetricsEditor_ValueTest));
        fieldPanel.add(this.valueTestField);
        labelPanel.add(new JLabel(Messages.MetricsEditor_ValuePresentation));
        fieldPanel.add(this.valuePresentationField);
        labelPanel.add(new JLabel(Messages.MetricsEditor_FormatName));
        fieldPanel.add(this.formatNameField);
        labelPanel.add(new JLabel(Messages.MetricsEditor_FormatPattern));
        fieldPanel.add(this.formatPatternField);
        this.add((Component)panel, "North");
        JPanel listPanel = new JPanel();
        this.add((Component)listPanel, "Center");
        JTable table = this.createFormatTable();
        JScrollPane scrollPane = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        listPanel.add(scrollPane);
        JPanel controlPanel = new JPanel();
        this.add((Component)controlPanel, "South");
        controlPanel.setLayout(new FlowLayout(0));
        JButton addTemplateButton = new JButton(Messages.MetricsEditor_AddFormatTemplate);
        addTemplateButton.setToolTipText(Messages.MetricsEditor_AddFormatTemplateTT);
        controlPanel.add(addTemplateButton);
        addTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MetricsEditor.this.addTemplate();
            }
        });
        JButton removeTemplateButton = new JButton(Messages.MetricsEditor_RemoveTemplate);
        removeTemplateButton.setToolTipText(Messages.MetricsEditor_RemoveTemplateTT);
        controlPanel.add(removeTemplateButton);
        removeTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MetricsEditor.this.removeTemplate();
            }
        });
        JButton updateTemplateButton = new JButton(Messages.MetricsEditor_UpdateTemplate);
        updateTemplateButton.setToolTipText(Messages.MetricsEditor_UpdateTemplateTT);
        controlPanel.add(updateTemplateButton);
        updateTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MetricsEditor.this.updateTemplate();
            }
        });
        JButton newFormatButton = new JButton(Messages.MetricsEditor_NewFormat);
        newFormatButton.setToolTipText(Messages.MetricsEditor_NewFormatTT);
        controlPanel.add(newFormatButton);
        newFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MetricsEditor.this.newFormat();
            }
        });
        this.valuePresentationField.setEditable(false);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MetricsEditor.this.updateValues();
            }
        };
        this.valueTestField.addActionListener(l);
        this.formatPatternField.addActionListener(l);
        this.valueTestField.setText(Messages.MetricsEditor_Numbers);
        this.formatPatternField.setText("%s");
        this.updateValues();
    }

    private void addTemplate() {
        MetricsFormat format = this.createMetricsFormatFromFields();
        try {
            this.formatList.addFormat(format);
        }
        catch (Exception exception) {}
    }

    private void updateTemplate() {
        int index = this.formatTable.getSelectedRow();
        if (index == -1) {
            return;
        }
        MetricsFormat format = this.createMetricsFormatFromFields();
        try {
            this.formatList.replaceFormatWith(this.formatList.getFormats()[index], format);
        }
        catch (Exception exception) {}
    }

    private void removeTemplate() {
        int index = this.formatTable.getSelectedRow();
        if (index == -1) {
            return;
        }
        try {
            this.formatList.removeFormat(this.formatList.getFormats()[index]);
        }
        catch (Exception exception) {}
    }

    public MetricsFormat getFormat() {
        return this.format;
    }

    private void newFormat() {
        this.format = null;
        this.formatNameField.setText(Messages.MetricsEditor_NewFormatField);
        this.formatPatternField.setText("%s");
        this.updateValues();
    }

    private JTable createFormatTable() {
        this.formatList = MetricsFormatList.getList();
        this.tableModel = new MetricsTableModel(this.formatList);
        this.formatTable = new JTable(this.tableModel);
        this.formatTable.doLayout();
        this.formatTable.setSelectionMode(0);
        this.formatTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = MetricsEditor.this.formatTable.getSelectionModel().getMinSelectionIndex();
                if (index == -1) {
                    return;
                }
                MetricsEditor.this.setMetricsFormat(MetricsEditor.this.formatList.getFormats()[index]);
            }
        });
        return this.formatTable;
    }

    private void updateValues() {
        String value = this.valueTestField.getText();
        if (value == null || value.length() == 0) {
            return;
        }
        Double d = null;
        try {
            d = Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            this.valuePresentationField.setText(Messages.MetricsEditor_ValueTestNotANumber);
            return;
        }
        this.formatValue = d;
        MetricsFormat format = null;
        try {
            format = this.createMetricsFormatFromFields();
        }
        catch (Exception e) {
            this.valuePresentationField.setText(NLS.bind((String)Messages.MetricsEditor_FormatPatternNotCorrect, (Object)e.getMessage()));
        }
        if (format == null) {
            return;
        }
        this.setMetricsFormat(format);
        this.tableModel.setFormatValue(this.formatValue);
    }

    private MetricsFormat createMetricsFormatFromFields() {
        if (this.formatPatternField.getText().length() == 0) {
            return null;
        }
        return new MetricsFormat(this.formatPatternField.getText(), 1.0, this.formatNameField.getText());
    }

    public void setMetricsFormat(MetricsFormat format) {
        this.format = format;
        try {
            this.valuePresentationField.setText(format.formatValue(this.formatValue));
        }
        catch (Exception e) {
            this.valuePresentationField.setText(NLS.bind((String)Messages.MetricsEditor_FormatError, (Object)e.getMessage()));
        }
        this.formatNameField.setText(format.getName());
        this.formatPatternField.setText(format.getPattern());
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    private class MetricsTableModel
    implements TableModel,
    MetricsFormatListListener {
        private String[] columnNames = new String[]{Messages.MetricsEditor_Name, Messages.MetricsEditor_Format, Messages.MetricsEditor_Value};
        private MetricsFormatList formatList;
        private double formatValue = 0.0;
        private List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        public MetricsTableModel(MetricsFormatList formatList) {
            this.formatList = formatList;
            this.formatList.addListener((MetricsFormatListListener)this);
        }

        public void setFormatValue(double value) {
            this.formatValue = value;
            this.fireChanged();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MetricsFormat format = this.formatList.getFormats()[rowIndex];
            if (columnIndex == 0) {
                return format.getName();
            }
            if (columnIndex == 1) {
                return format.getPattern();
            }
            if (columnIndex == 2) {
                return format.formatValue(this.formatValue);
            }
            throw new IndexOutOfBoundsException("There is no column " + columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.formatList.getFormats().length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        public void onListChanged(MetricsFormatList sender) {
            this.fireChanged();
        }

        private void fireChanged() {
            for (TableModelListener l : this.listeners) {
                l.tableChanged(new TableModelEvent(this));
            }
        }

        public void dispose() {
            this.formatList.removeListener((MetricsFormatListListener)this);
        }
    }
}

