/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.ui.actions.Messages;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;

public class NewProceduralComponentType
implements ActionFactory {
    public static Resource create(WriteGraph graph, Resource library) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)library);
        Resource componentType = graph.newResource();
        graph.newClusterSet(componentType);
        CommonDBUtils.selectClusterSet((WriteGraph)graph, (Resource)componentType);
        Layer0Utils.claimNewIdentifier((WriteGraph)graph, (Resource)componentType, (boolean)true);
        graph.claim(componentType, L0.PartOf, library);
        Resource indexRoot = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(library));
        Resource supertype = graph.getSingleObject(indexRoot, MOD.StructuralModel_HasComponentTypeSupertype);
        graph.claim(componentType, L0.Inherits, null, supertype);
        graph.claim(componentType, L0.InstanceOf, STR.ProceduralComponentType);
        String defaultName = (String)graph.getRelatedValue(indexRoot, MOD.StructuralModel_HasDefaultComponentTypeName, (Binding)Bindings.STRING);
        String name = NameUtils.findFreshName((ReadGraph)graph, (String)defaultName, (Resource)library);
        graph.claimLiteral(componentType, L0.HasName, (Object)(name + "@1"));
        graph.claimLiteral(componentType, L0X.HasGeneratedNamePrefix, (Object)"");
        graph.addLiteral(componentType, STR.ProceduralComponentType_code, STR.ProceduralComponentType_code_Inverse, STR.ProceduralComponentTypeCode, (Object)"[]", (Binding)Bindings.STRING);
        Resource symbolDiagramType = graph.getPossibleObject(indexRoot, MOD.StructuralModel_HasSymbolDiagramType);
        if (symbolDiagramType == null) {
            symbolDiagramType = DIA.Composite;
        }
        Resource symbol = new ModelingUtils(graph).createSymbol2("Symbol", symbolDiagramType);
        graph.claim(componentType, MOD.ComponentTypeToSymbol, symbol);
        graph.claim(componentType, L0.ConsistsOf, symbol);
        return componentType;
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource library = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                DatabaseJob job = new DatabaseJob(Messages.NewProceduralComponentType_NewUserComponent){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                                public void perform(WriteGraph graph) throws DatabaseException {
                                    graph.markUndoPoint();
                                    Resource r = NewProceduralComponentType.create(graph, library);
                                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created new Procedural Component Type " + String.valueOf(graph.getPossibleRelatedValue2(r, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING))));
                                }
                            });
                            return Status.OK_STATUS;
                        }
                        catch (DatabaseException e) {
                            return new Status(4, "org.simantics.modeling.ui", Messages.NewProceduralComponentType_ActivatorFailedToCreateNewUserComponent, (Throwable)e);
                        }
                    }
                };
                job.schedule();
            }
        };
    }
}

