/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.actions.Messages;
import org.simantics.modeling.userComponent.ComponentTypeCommands;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.dialogs.ResourceSelectionDialog3;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ErrorLogger;

public class NewConnectionPoint
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource componentType = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                try {
                    Map map = (Map)Simantics.sync((ReadInterface)new UniqueRead<Map<Resource, Pair<String, ImageDescriptor>>>(){

                        public Map<Resource, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
                            HashMap<Resource, Pair<String, ImageDescriptor>> map = new HashMap<Resource, Pair<String, ImageDescriptor>>();
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                            Instances query = (Instances)graph.adapt(STR.ConnectionRelation, Instances.class);
                            Resource model = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(componentType));
                            for (Resource _res : query.find(graph, model)) {
                                boolean isDiagramRelation = graph.hasStatement(_res, MOD.DiagramConnectionRelationToConnectionRelation);
                                if (isDiagramRelation) continue;
                                Collection domains = graph.getObjects(_res, L0.HasDomain);
                                Object name = null;
                                if (domains.size() == 0) continue;
                                if (domains.size() > 1) {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)_res));
                                    name = sb.toString();
                                } else {
                                    name = NameUtils.getSafeName((ReadGraph)graph, (Resource)_res) + " (" + graph.getURI((Resource)domains.iterator().next()) + ")";
                                }
                                map.put(_res, (Pair<String, ImageDescriptor>)new Pair(name, null));
                            }
                            return map;
                        }
                    });
                    final Resource[] cps = NewConnectionPoint.this.queryCps(map);
                    if (cps.length == 0) {
                        return;
                    }
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            Resource[] resourceArray = cps;
                            int n = cps.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Resource cp = resourceArray[n2];
                                ComponentTypeCommands.createConnectionPoint((WriteGraph)graph, (Resource)componentType, (Resource)cp);
                                ++n2;
                            }
                            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)this.createConnectionPointComment((ReadGraph)graph, componentType, cps));
                        }

                        String createConnectionPointComment(ReadGraph graph, Resource target, Resource[] cps2) throws DatabaseException {
                            StringBuilder result = new StringBuilder();
                            result.append("Created connection point");
                            if (cps2.length > 1) {
                                result.append('s');
                            }
                            result.append(" for ").append(NameUtils.getSafeName((ReadGraph)graph, (Resource)componentType)).append(":\n");
                            int i = 0;
                            while (i < cps2.length) {
                                result.append('\t');
                                result.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)cps2[i]));
                                result.append('\n');
                                ++i;
                            }
                            return result.toString();
                        }
                    });
                }
                catch (DatabaseException e1) {
                    ErrorLogger.defaultLogError((Throwable)e1);
                }
            }
        };
    }

    private Resource[] queryCps(Map<Resource, Pair<String, ImageDescriptor>> map) {
        Object[] result;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ResourceSelectionDialog3<Resource> dialog = new ResourceSelectionDialog3<Resource>(shell, map, Messages.NewConnectionPoint_SelectConnectionPointType){

            protected IDialogSettings getBaseDialogSettings() {
                return Activator.getDefault().getDialogSettings();
            }
        };
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
            Resource[] res = new Resource[result.length];
            System.arraycopy(result, 0, res, 0, result.length);
            return res;
        }
        return Resource.NONE;
    }
}

