/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.model.actions.ActionBrowseContext;
import org.simantics.browsing.ui.model.actions.IActionCategory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.action.PriorityAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeledDoubleClickActions
implements IDoubleClickAction,
IExecutableExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeledDoubleClickActions.class);
    private Set<String> browseContexts = defaultBrowseContexts;
    public static final Set<String> defaultBrowseContexts = Collections.singleton("http://www.simantics.org/Project-1.2/ProjectDoubleClickActionContext");

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] parms;
            String str = (String)data;
            String[] stringArray = parms = str.split(";");
            int n = parms.length;
            int n2 = 0;
            while (n2 < n) {
                String key;
                String parm = stringArray[n2];
                String[] keyValue = parm.split("=");
                if (keyValue.length == 2 && "context".equals(key = keyValue[0].trim())) {
                    this.browseContexts = Collections.singleton(keyValue[1]);
                }
                ++n2;
            }
        }
    }

    public Collection<String> getBrowseContexts() {
        return this.browseContexts;
    }

    public Collection<Resource> getBrowseContextResources(ReadGraph graph) throws DatabaseException {
        Collection<String> names = this.getBrowseContexts();
        ArrayList<Resource> result = new ArrayList<Resource>(names.size());
        for (String name : names) {
            result.add(graph.getResource(name));
        }
        return result;
    }

    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        ReadGraph g = e.getGraph();
        Resource resource = ResourceAdaptionUtils.toSingleResource((Object)e.getResource());
        if (resource == null) {
            return;
        }
        Collection actions = (Collection)g.syncRequest((Read)new ResourceRead<Collection<IPriorityAction>>(resource){

            public Collection<IPriorityAction> perform(ReadGraph graph) throws DatabaseException {
                List<NodeContext> contexts = Collections.singletonList(NodeContextBuilder.buildWithInput((Object)this.resource));
                try {
                    NodeContext nodeContext = contexts.get(0);
                    ActionBrowseContext defaultABC = ActionBrowseContext.create((ReadGraph)graph, ModeledDoubleClickActions.this.getBrowseContextResources(graph));
                    ActionBrowseContext nodeABC = ActionBrowseContext.resolve((ReadGraph)graph, (NodeContext)nodeContext);
                    ActionBrowseContext browseContext = defaultABC.merge(graph, nodeABC);
                    Map result = browseContext.getActions(graph, nodeContext, contexts);
                    return ModeledDoubleClickActions.toContributionItems(result);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Error while resolving modeled double-click actions", (Throwable)e);
                    return Collections.emptyList();
                }
            }
        });
        for (IPriorityAction act : actions) {
            e.add(act);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<IPriorityAction> toContributionItems(Map<IActionCategory, List<Action>> map) {
        if (map.isEmpty()) {
            return Collections.emptyList();
        }
        IActionCategory[] categories = map.keySet().toArray(new IActionCategory[map.size()]);
        Arrays.sort(categories, IActionCategory.ACTION_CATEGORY_COMPARATOR);
        ArrayList<IPriorityAction> items = new ArrayList<IPriorityAction>();
        IActionCategory[] iActionCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IActionCategory category = iActionCategoryArray[n2];
            List<Action> actions = map.get(category);
            for (final Action act : actions) {
                Action action = act;
                if (action instanceof IPriorityAction) {
                    void pa;
                    IPriorityAction cfr_ignored_0 = (IPriorityAction)action;
                    IPriorityAction cfr_ignored_1 = (IPriorityAction)action;
                    items.add((IPriorityAction)pa);
                    continue;
                }
                items.add((IPriorityAction)new PriorityAction(0, act.getText()){

                    public void run() {
                        act.run();
                    }
                });
            }
            ++n2;
        }
        return items;
    }
}

