/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.util.DraftStatusBean;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.ui.sharedontology.wizard.ExportPlan;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ISelectionUtils;

public class ModelExportPage
extends WizardPage {
    ExportPlan exportModel;
    Composite draft;
    CCombo model;
    CCombo exportLocation;
    List<ModelingUtils.LibraryInfo> models = Collections.emptyList();
    private Button overwrite;
    private Button dependencies;

    protected ModelExportPage(ExportPlan model) {
        super("Export Model", "Define Export Location", null);
        this.exportModel = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.draft = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.draft);
        this.draft.setBackground(this.draft.getDisplay().getSystemColor(3));
        GridLayoutFactory.swtDefaults().spacing(5, 5).applyTo(this.draft);
        Composite draft2 = new Composite(this.draft, 0);
        GridLayoutFactory.swtDefaults().applyTo(draft2);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)draft2);
        Label draftText = new Label(draft2, 64);
        draftText.setText("Some dependencies of the selected model are not published. The model can only be saved with draft status.");
        new Label(container, 0).setText("Exported &model:");
        this.model = new CCombo(container, 2048);
        this.model.setEditable(false);
        this.model.setText("");
        this.model.setToolTipText("Selects the model to export.");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.model);
        this.model.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selected = ModelExportPage.this.model.getSelectionIndex();
                if (selected != -1) {
                    ModelExportPage.this.exportModel.model = (ModelingUtils.LibraryInfo)ModelExportPage.this.model.getData(String.valueOf(selected));
                    ModelExportPage.this.validatePage();
                }
            }
        });
        new Label(container, 0).setText("&Target file:");
        this.exportLocation = new CCombo(container, 2048);
        this.exportLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
        this.exportLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelExportPage.this.validatePage();
            }
        });
        Button browseFileButton = new Button(container, 8);
        browseFileButton.setText("Browse...");
        browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ModelExportPage.this.getShell(), 8192);
                dialog.setText("Choose Export Target File");
                String loc = ModelExportPage.this.exportLocation.getText();
                dialog.setFilterPath(loc);
                dialog.setFilterExtensions(new String[]{"*.tg"});
                dialog.setFilterNames(new String[]{"Model (*.tg)"});
                dialog.setOverwrite(false);
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                ModelExportPage.this.exportLocation.setText(file);
                ModelExportPage.this.validatePage();
            }
        });
        Label horizRule = new Label(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, 0).grab(true, false).span(3, 1).applyTo((Control)horizRule);
        this.overwrite = new Button(container, 32);
        this.overwrite.setText("&Overwrite existing files without warning");
        this.overwrite.setSelection(this.exportModel.overwrite);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.overwrite);
        this.overwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelExportPage.this.validatePage();
            }
        });
        this.dependencies = new Button(container, 32);
        this.dependencies.setText("&Export dependencies");
        this.dependencies.setSelection(this.exportModel.includeDependencies);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.dependencies);
        this.dependencies.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelExportPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.setControl((Control)container);
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        final List selected = ISelectionUtils.getPossibleKeys((Object)this.exportModel.selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        this.models = (List)this.exportModel.sessionContext.getSession().syncRequest((Read)new UniqueRead<List<ModelingUtils.LibraryInfo>>(){

            public List<ModelingUtils.LibraryInfo> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<ModelingUtils.LibraryInfo> result = new ArrayList<ModelingUtils.LibraryInfo>();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                for (Resource r : selected) {
                    Resource model = r;
                    if (!graph.isInstanceOf(model, SIMU.Model) && !graph.isInstanceOf(model = (Resource)graph.syncRequest((Read)new IndexRoot(r)), SIMU.Model)) continue;
                    String name = (String)graph.getRelatedValue(model, L0.HasName, (Binding)Bindings.STRING);
                    DraftStatusBean draft = ModelingUtils.getDependencyDraftStatus((ReadGraph)graph, (Resource)model);
                    result.add(new ModelingUtils.LibraryInfo(name, model, draft));
                }
                Collections.sort(result, new Comparator<ModelingUtils.LibraryInfo>(){

                    @Override
                    public int compare(ModelingUtils.LibraryInfo o1, ModelingUtils.LibraryInfo o2) {
                        return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.library.getName(), (Object)o2.library.getName());
                    }
                });
                return result;
            }
        });
        if (!this.models.isEmpty()) {
            this.exportModel.model = this.models.get(0);
        }
        int i = 0;
        for (ModelingUtils.LibraryInfo m : this.models) {
            this.model.add(m.library.getName());
            this.model.setData(String.valueOf(i), (Object)m);
            if (m.equals((Object)this.exportModel.model)) {
                this.model.select(i);
            }
            ++i;
        }
        for (String path : this.exportModel.recentLocations) {
            this.exportLocation.add(path);
        }
        if (this.exportLocation.getItemCount() > 0) {
            this.exportLocation.select(0);
        }
    }

    void validatePage() {
        String exportLoc;
        boolean hasDraftDependencies;
        if (this.exportModel.model == null) {
            this.setMessage("Select library to export from.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        boolean draftVisible = this.draft.getVisible();
        boolean bl = hasDraftDependencies = this.exportModel.model.draft != null;
        if (draftVisible != hasDraftDependencies) {
            ((GridData)this.draft.getLayoutData()).exclude = !hasDraftDependencies;
            this.draft.setVisible(hasDraftDependencies);
            this.draft.getParent().getParent().layout(true, true);
        }
        if ((exportLoc = this.exportLocation.getText()).isEmpty()) {
            this.setMessage("Select target file.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        File file = new File(exportLoc);
        if (file.isDirectory()) {
            this.setErrorMessage("The target is a directory.");
            this.setPageComplete(false);
            return;
        }
        File parent = file.getParentFile();
        if (parent == null || !parent.isDirectory()) {
            this.setErrorMessage("The target directory does not exist.");
            this.setPageComplete(false);
            return;
        }
        this.exportModel.exportLocation = file;
        this.exportModel.overwrite = this.overwrite.getSelection();
        this.exportModel.includeDependencies = this.dependencies.getSelection();
        this.setErrorMessage(null);
        this.setMessage("Export selected model to " + String.valueOf(this.exportModel.exportLocation) + ".");
        this.setPageComplete(true);
    }
}

