/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfWriter;
import java.util.concurrent.Semaphore;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.ui.pdf.PDFBuilder;
import org.simantics.modeling.ui.pdf.PDFExportPlan;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class PDFPainter {
    public static void render(IThreadWorkQueue thread, PDFExportPlan exportModel, Node node, PdfWriter writer, FontMapper mapper, Rectangle pageSize, PageDesc pageDesc, boolean fitDiagramContentsToPageMargins, long timeout) throws InterruptedException, DatabaseException {
        DatabaseException[] exception = new DatabaseException[1];
        ICanvasSceneGraphProvider[] sgProvider = new ICanvasSceneGraphProvider[1];
        CanvasContext ctx = new CanvasContext(thread);
        ctx.getDefaultHintContext().setHint(Hints.KEY_DISABLE_GRAPH_MODIFICATIONS, (Object)Boolean.TRUE);
        try {
            Semaphore done = new Semaphore(0);
            ThreadUtils.getBlockingWorkExecutor().execute(() -> {
                try {
                    try {
                        ICanvasSceneGraphProvider provider;
                        Session s = pDFExportPlan.sessionContext.getSession();
                        Pair modelAndRVI = (Pair)s.syncRequest(PDFPainter.modelAndRVI(node));
                        Boolean isSymbol = (Boolean)s.syncRequest(PDFPainter.isSymbol(node));
                        iCanvasSceneGraphProviderArray[0] = provider = DiagramNodeUtil.loadSceneGraphProvider((ICanvasContext)ctx, (Resource)((Resource)modelAndRVI.first), (Resource)node.getDiagramResource(), (String)((String)modelAndRVI.second), (int)5000);
                        ctx.getDefaultHintContext().setHint(Hints.KEY_PAGE_DESC, (Object)pageDesc);
                        ThreadUtils.asyncExec((IThreadWorkQueue)thread, () -> {
                            try {
                                try {
                                    boolean fitToContent;
                                    boolean bl3 = fitToContent = fitDiagramContentsToPageMargins || isSymbol != false;
                                    if (!fitToContent) {
                                        ctx.getDefaultHintContext().setHint(Hints.KEY_DISPLAY_PAGE, (Object)false);
                                    }
                                    PDFBuilder chassis = new PDFBuilder(writer, mapper, pageSize, pageDesc, fitToContent);
                                    chassis.paint((ICanvasContext)ctx, true);
                                }
                                catch (Throwable e) {
                                    databaseExceptionArray[0] = new DatabaseException(e);
                                    done.release();
                                }
                            }
                            finally {
                                done.release();
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        done.release();
                        databaseExceptionArray[0] = e;
                        done.release();
                    }
                    catch (Throwable e) {
                        done.release();
                        databaseExceptionArray[0] = new DatabaseException(e);
                        done.release();
                    }
                }
                finally {
                    done.release();
                }
            });
            done.acquire(2);
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        finally {
            if (sgProvider[0] != null) {
                sgProvider[0].dispose();
            }
            ctx.dispose();
        }
    }

    private static Read<Pair<Resource, String>> modelAndRVI(final Node node) {
        return new UniqueRead<Pair<Resource, String>>(){

            public Pair<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                return Pair.make((Object)PDFPainter.resolveModel(graph, node), (Object)PDFPainter.resolveRVI(graph, node));
            }
        };
    }

    private static Read<Boolean> isSymbol(final Node node) {
        return new UniqueRead<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                Resource possibleSymbol = graph.getPossibleObject(node.getDiagramResource(), STR.Defines);
                if (possibleSymbol != null && graph.isInstanceOf(possibleSymbol, DIA.ElementClass)) {
                    return true;
                }
                return false;
            }
        };
    }

    private static Resource resolveModel(ReadGraph graph, Node node) throws DatabaseException {
        Resource composite = node.getDefiningResources().head();
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(composite));
        if (model == null) {
            throw new ValidationException("no model found for composite " + NameUtils.getSafeName((ReadGraph)graph, (Resource)composite));
        }
        return model;
    }

    private static String resolveRVI(ReadGraph graph, Node node) throws DatabaseException {
        String RVI2 = node.getRVI();
        if (RVI2 != null) {
            return RVI2;
        }
        Resource composite = node.getDefiningResources().head();
        Variable var = Variables.getVariable((ReadGraph)graph, (Resource)composite);
        RVI rvi = var.getPossibleRVI(graph);
        return rvi != null ? rvi.toString() : null;
    }
}

