/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.simantics.browsing.ui.common.views.DefaultFilterStrategy;
import org.simantics.browsing.ui.common.views.IFilterStrategy;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.requests.Nodes;
import org.simantics.modeling.ui.pdf.DiagramPrinter;
import org.simantics.modeling.ui.pdf.Messages;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ISelectionUtils;

public class NodeTree
extends Composite {
    public static final String COLUMN_KEY_DIAGRAM = "diagram";
    public static final String COLUMN_KEY_DOC = "doc";
    protected Display display;
    protected LocalResourceManager resourceManager;
    protected Color noContentColor;
    protected Color availableColor;
    protected Color includedColor;
    protected IFilterStrategy filterStrategy = new DefaultFilterStrategy();
    protected Text filter;
    protected Matcher matcher = null;
    protected CheckboxTreeViewer tree;
    protected Button selectSubtreeToggle;
    protected TreePath[] noFilterExpandedPaths;
    protected Set<Node> selectedNodes;
    protected CheckStateCache checkStateCache = new CheckStateCache();
    protected Runnable selectionChangeListener;
    protected CollectionResult nodes;
    private BiPredicate<Node, String> inclusionFilter = (n, k) -> true;
    private transient boolean selectSubtreeEnabled = true;
    private Runnable resetFilter = () -> this.resetFilterString(this.filter.getText());

    public NodeTree(Composite parent, Set<Node> selectedNodes) {
        super(parent, 0);
        this.display = this.getDisplay();
        this.selectedNodes = selectedNodes;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
        this.noContentColor = this.getDisplay().getSystemColor(16);
        this.availableColor = this.getDisplay().getSystemColor(3);
        this.includedColor = this.getDisplay().getSystemColor(9);
        GridLayoutFactory.fillDefaults().spacing(20, 10).numColumns(3).applyTo((Composite)this);
        this.createFilter(this);
        this.createTree(this);
        this.createButtons(this);
    }

    public void setInclusionFilter(BiPredicate<Node, String> f) {
        this.inclusionFilter = f != null ? f : (n, k) -> true;
    }

    public void setSelectionChangeListener(Runnable r) {
        this.selectionChangeListener = r;
    }

    public void setInput(CollectionResult nodes) {
        this.nodes = nodes;
        this.tree.setInput((Object)nodes);
        this.resetFilterString(this.filter.getText());
    }

    private void createFilter(Composite parent) {
        Label filterLabel = new Label(parent, 0);
        filterLabel.setText(Messages.NodeTree_Filter);
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)filterLabel);
        this.filter = new Text(parent, 2048);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.filter);
        this.filter.addModifyListener(e -> this.display.timerExec(500, this.resetFilter));
    }

    private void createTree(Composite parent) {
        Composite treeParent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(3, 1).applyTo((Control)treeParent);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        treeParent.setLayout((Layout)treeLayout);
        this.tree = new CheckboxTreeViewer(treeParent, 67586);
        this.tree.getTree().setLinesVisible(true);
        this.tree.getTree().setHeaderVisible(true);
        this.tree.setUseHashlookup(true);
        this.tree.getControl().setToolTipText(Messages.NodeTree_Tooltip);
        this.tree.setAutoExpandLevel(2);
        this.tree.addCheckStateListener((ICheckStateListener)new CheckStateListener());
        this.tree.setContentProvider((IContentProvider)new NodeTreeContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new NodeLabelProvider());
        this.tree.setCheckStateProvider((ICheckStateProvider)new NodeCheckStateProvider());
        this.tree.setComparator(new ViewerComparator((Comparator)AlphanumComparator.CASE_INSENSITIVE_COMPARATOR));
        this.tree.setFilters(new ViewerFilter[]{new NodeFilter()});
        TreeViewerColumn c1 = new TreeViewerColumn((TreeViewer)this.tree, 16384);
        c1.getColumn().setText(Messages.NodeTree_Column_Item);
        c1.getColumn().setWidth(200);
        c1.setLabelProvider((CellLabelProvider)new NodeLabelProvider());
        treeLayout.setColumnData((Widget)c1.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 200));
        TreeViewerColumn c2 = new TreeViewerColumn((TreeViewer)this.tree, 0x1000000);
        c2.getColumn().setText(Messages.NodeTree_Column_Diagram);
        c2.getColumn().setWidth(130);
        c2.setLabelProvider((CellLabelProvider)new HasDiagramLabelProvider());
        treeLayout.setColumnData((Widget)c2.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 130));
        TreeViewerColumn c3 = new TreeViewerColumn((TreeViewer)this.tree, 0x1000000);
        c3.getColumn().setText(Messages.NodeTree_Column_Documentation);
        c3.getColumn().setWidth(130);
        c3.setLabelProvider((CellLabelProvider)new HasDocLabelProvider());
        treeLayout.setColumnData((Widget)c3.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, 130));
    }

    private void createButtons(Composite parent) {
        Composite bar = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)bar);
        bar.setLayout((Layout)new RowLayout());
        this.selectSubtreeToggle = new Button(bar, 2);
        this.selectSubtreeToggle.setText(Messages.NodeTree_SubtreeSelection_Text);
        this.selectSubtreeToggle.setToolTipText(NodeTree.subtreeToggleTooltip(false));
        this.selectSubtreeToggle.setSelection(this.selectSubtreeEnabled);
        this.selectSubtreeToggle.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.selectSubtreeEnabled = this.selectSubtreeToggle.getSelection();
            this.refreshTree(true);
        }));
        Button expand = new Button(bar, 8);
        expand.setText(Messages.NodeTree_Expand_Text);
        expand.setToolTipText(Messages.NodeTree_Expand_Tooltip);
        expand.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ITreeSelection ss = this.tree.getStructuredSelection();
            if (ss.isEmpty()) {
                this.tree.expandAll();
            } else {
                for (Object n : ss.toList()) {
                    this.tree.expandToLevel(n, -1);
                }
            }
            this.scheduleFocusTree();
        }));
        Button collapse = new Button(bar, 8);
        collapse.setText(Messages.NodeTree_Collapse_Text);
        collapse.setToolTipText(Messages.NodeTree_Collapse_Tooltip);
        collapse.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ITreeSelection ss = this.tree.getStructuredSelection();
            if (ss.isEmpty()) {
                this.tree.collapseAll();
            } else {
                for (Object n : ss.toList()) {
                    this.tree.collapseToLevel(n, -1);
                }
            }
            this.scheduleFocusTree();
        }));
    }

    protected void fireChangeListener() {
        if (this.selectionChangeListener != null) {
            this.selectionChangeListener.run();
        }
    }

    protected void scheduleFocusTree() {
        this.display.asyncExec(() -> {
            if (!this.tree.getTree().isDisposed() && !this.tree.getTree().isFocusControl()) {
                this.tree.getTree().setFocus();
            }
        });
    }

    private Collection<Node> getVisibleNodes() {
        ArrayList<Node> result = new ArrayList<Node>();
        ArrayDeque<TreeItem> todo = new ArrayDeque<TreeItem>();
        TreeItem[] treeItemArray = this.tree.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            todo.add(ti);
            ++n2;
        }
        while (!todo.isEmpty()) {
            TreeItem item = (TreeItem)todo.removeLast();
            Node node = (Node)item.getData();
            if (node != null) {
                result.add(node);
            }
            TreeItem[] treeItemArray2 = item.getItems();
            int n3 = treeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                TreeItem child = treeItemArray2[n4];
                todo.add(child);
                ++n4;
            }
        }
        return result;
    }

    private void resetFilterString(String filterString) {
        TreePath[] restoreExpansions = null;
        String patternString = this.filterStrategy.toPatternString(filterString);
        if (patternString == null) {
            if (this.matcher != null) {
                restoreExpansions = this.noFilterExpandedPaths;
                this.noFilterExpandedPaths = null;
            }
            this.matcher = null;
        } else {
            if (this.matcher == null) {
                this.noFilterExpandedPaths = this.tree.getExpandedTreePaths();
            }
            this.matcher = Pattern.compile(patternString).matcher("");
        }
        this.selectSubtreeToggle.setToolTipText(NodeTree.subtreeToggleTooltip(this.matcher != null));
        this.refreshTree(false);
        if (restoreExpansions != null) {
            this.tree.setExpandedTreePaths(restoreExpansions);
        } else {
            this.tree.expandAll();
        }
    }

    protected static boolean hasPrintables(Node n) {
        return Nodes.HAS_PRINTABLES_PREDICATE.test(n);
    }

    protected boolean hasPrintablesDeep0(Node n) {
        if (NodeTree.hasPrintables(n)) {
            return true;
        }
        for (Node c : n.getChildren()) {
            if (!this.hasPrintablesDeep(c)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasPrintablesDeep(Node n) {
        Boolean r = this.checkStateCache.hasPrintablesDeep.get(n);
        if (r != null) {
            return r;
        }
        r = this.hasPrintablesDeep0(n);
        this.checkStateCache.hasPrintablesDeep.put(n, r);
        return r;
    }

    protected boolean isSomethingSelected(Node node) {
        if (NodeTree.hasPrintables(node) && this.selectedNodes.contains(node)) {
            return true;
        }
        Collection children = node.getChildren();
        if (!children.isEmpty()) {
            for (Node child : children) {
                if (!this.hasPrintablesDeep(child) || !this.isSomethingSelected(child)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isFullySelected(Node node) {
        boolean hp = NodeTree.hasPrintables(node);
        boolean thisSelected = this.selectedNodes.contains(node);
        if (hp && !thisSelected) {
            return false;
        }
        Collection children = node.getChildren();
        if (children.isEmpty()) {
            return hp && thisSelected;
        }
        int selectedCount = 0;
        int printableCount = 0;
        boolean allChildrenSelected = true;
        for (Node child : children) {
            if (!this.hasPrintablesDeep(child)) continue;
            ++printableCount;
            boolean childSelected = this.isFullySelected(child);
            allChildrenSelected &= childSelected;
            selectedCount += childSelected ? 1 : 0;
            if (!childSelected) break;
        }
        return allChildrenSelected && (printableCount == 0 || selectedCount > 0 && printableCount > 0);
    }

    protected boolean isPartiallySelected(Node node) {
        return this.isSomethingSelected(node) && !this.isFullySelected(node);
    }

    protected void refreshTree(boolean invalidateCheckStateCache) {
        if (invalidateCheckStateCache) {
            this.checkStateCache.invalidate();
        }
        this.tree.refresh();
    }

    public void refreshTree() {
        this.refreshTree(true);
    }

    public boolean addOrRemoveSelection(Node node, boolean add) {
        boolean changed = false;
        if (NodeTree.hasPrintables(node) && (changed = add ? this.selectedNodes.add(node) : this.selectedNodes.remove(node))) {
            this.checkStateCache.invalidate(node);
        }
        return changed;
    }

    public boolean addOrRemoveSelectionRec(Node node, boolean add, Predicate<Node> filter) {
        boolean changed = false;
        if (filter == null || filter.test(node)) {
            changed |= this.addOrRemoveSelection(node, add);
        }
        for (Node child : node.getChildren()) {
            changed |= this.addOrRemoveSelectionRec(child, add, filter);
        }
        return changed;
    }

    public TreePath[] getExpandedPaths() {
        return this.tree.getExpandedTreePaths();
    }

    public void setExpandedPaths(TreePath[] expanded) {
        this.tree.setExpandedTreePaths(expanded);
    }

    public void withRedrawDisabled(Runnable r) {
        Tree t = this.tree.getTree();
        t.setRedraw(false);
        try {
            r.run();
        }
        finally {
            t.setRedraw(true);
        }
    }

    private static String subtreeToggleTooltip(boolean hasFilter) {
        return hasFilter ? Messages.NodeTree_SubtreeSelection_Tooltip_Filtered : Messages.NodeTree_SubtreeSelection_Tooltip;
    }

    private static class CheckStateCache {
        Map<Node, Boolean> isChecked = new HashMap<Node, Boolean>();
        Map<Node, Boolean> isGrayed = new HashMap<Node, Boolean>();
        Map<Node, Boolean> hasPrintablesDeep = new HashMap<Node, Boolean>();

        private CheckStateCache() {
        }

        public void invalidate(Node n) {
            while (n != null) {
                this.isChecked.remove(n);
                this.isGrayed.remove(n);
                this.hasPrintablesDeep.remove(n);
                n = n.getParent();
            }
        }

        public void invalidate() {
            this.isChecked.clear();
            this.isGrayed.clear();
            this.hasPrintablesDeep.clear();
        }
    }

    private class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            HashSet<Node> visible;
            boolean checked = event.getChecked();
            Node checkedNode = (Node)event.getElement();
            if (!checked && NodeTree.hasPrintables(checkedNode) && NodeTree.this.checkStateCache.isGrayed.getOrDefault(checkedNode, Boolean.FALSE).booleanValue()) {
                checked = true;
            }
            HashSet<Node> nodes = new HashSet<Node>();
            Set selection = ISelectionUtils.filterSetSelection((Object)NodeTree.this.tree.getSelection(), Node.class);
            if (selection.contains(checkedNode)) {
                nodes.addAll(selection);
            } else {
                NodeTree.this.tree.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            nodes.add(checkedNode);
            boolean treeIsFiltered = !NodeTree.this.filter.getText().isEmpty();
            HashSet<Node> hashSet = visible = treeIsFiltered && NodeTree.this.selectSubtreeEnabled ? new HashSet<Node>(NodeTree.this.getVisibleNodes()) : null;
            Predicate<Node> filter = visible != null ? visible::contains : null;
            for (Node node : nodes) {
                if (NodeTree.this.selectSubtreeEnabled) {
                    NodeTree.this.addOrRemoveSelectionRec(node, checked, filter);
                    continue;
                }
                NodeTree.this.addOrRemoveSelection(node, checked);
            }
            NodeTree.this.tree.refresh();
            NodeTree.this.fireChangeListener();
        }
    }

    private class HasDiagramLabelProvider
    extends CellLabelProvider {
        private HasDiagramLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object e = cell.getElement();
            if (e instanceof Node) {
                Node n = (Node)e;
                if (n.getDiagramResource() != null) {
                    if (NodeTree.this.selectedNodes.contains(n) && NodeTree.this.inclusionFilter.test(n, NodeTree.COLUMN_KEY_DIAGRAM)) {
                        cell.setText(Messages.NodeTree_Included);
                        cell.setForeground(NodeTree.this.includedColor);
                    } else {
                        cell.setText(Messages.NodeTree_Available);
                        cell.setForeground(NodeTree.this.availableColor);
                    }
                } else {
                    cell.setText(Messages.NodeTree_NoContent);
                    cell.setForeground(NodeTree.this.noContentColor);
                }
            }
        }
    }

    private class HasDocLabelProvider
    extends CellLabelProvider {
        private HasDocLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object e = cell.getElement();
            if (e instanceof Node) {
                Node n = (Node)e;
                if (n.hasProperty(NodeTree.COLUMN_KEY_DOC)) {
                    if (NodeTree.this.selectedNodes.contains(n) && NodeTree.this.inclusionFilter.test(n, NodeTree.COLUMN_KEY_DOC)) {
                        cell.setText(Messages.NodeTree_Included);
                        cell.setForeground(NodeTree.this.includedColor);
                    } else {
                        cell.setText(Messages.NodeTree_Available);
                        cell.setForeground(NodeTree.this.availableColor);
                    }
                } else {
                    cell.setText(Messages.NodeTree_NoContent);
                    cell.setForeground(NodeTree.this.noContentColor);
                }
            }
        }
    }

    private class NodeCheckStateProvider
    implements ICheckStateProvider {
        private NodeCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            Node n = (Node)element;
            Boolean cache = NodeTree.this.checkStateCache.isChecked.get(n);
            if (cache != null) {
                return cache;
            }
            boolean checked = false;
            checked = NodeTree.this.selectSubtreeEnabled ? NodeTree.this.isSomethingSelected(n) : NodeTree.this.selectedNodes.contains(n);
            NodeTree.this.checkStateCache.isChecked.put(n, checked);
            return checked;
        }

        public boolean isGrayed(Object element) {
            Node n = (Node)element;
            Boolean cache = NodeTree.this.checkStateCache.isGrayed.get(n);
            if (cache != null) {
                return cache;
            }
            boolean grayed = false;
            if (NodeTree.this.selectSubtreeEnabled) {
                grayed = NodeTree.this.isPartiallySelected(n);
            }
            NodeTree.this.checkStateCache.isGrayed.put(n, grayed);
            return grayed;
        }
    }

    private class NodeFilter
    extends ViewerFilter {
        private NodeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (NodeTree.this.matcher == null) {
                return true;
            }
            Node node = (Node)element;
            boolean matches = NodeTree.this.matcher.reset(node.getName().toLowerCase()).matches();
            if (matches) {
                return true;
            }
            for (Node child : node.getChildren()) {
                if (!this.select(viewer, element, child)) continue;
                return true;
            }
            return false;
        }
    }

    private class NodeLabelProvider
    extends CellLabelProvider {
        private NodeLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object e = cell.getElement();
            if (e instanceof Node) {
                Node n = (Node)e;
                String name = DiagramPrinter.formDiagramName(n, false);
                cell.setText(name);
                if (!Nodes.HAS_PRINTABLES_PREDICATE.test(n)) {
                    cell.setForeground(NodeTree.this.noContentColor);
                } else {
                    cell.setForeground(null);
                }
            }
        }
    }

    private class NodeTreeContentProvider
    implements ITreeContentProvider {
        private NodeTreeContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CollectionResult) {
                return ((CollectionResult)inputElement).roots.toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            Node n = (Node)element;
            Collection children = n.getChildren();
            if (children.isEmpty()) {
                return false;
            }
            for (Node c : children) {
                if (!NodeTree.this.hasPrintablesDeep(c)) continue;
                return true;
            }
            return false;
        }

        public Object getParent(Object element) {
            return ((Node)element).getParent();
        }

        public Object[] getChildren(Object parentElement) {
            Node n = (Node)parentElement;
            ArrayList<Node> result = new ArrayList<Node>(n.getChildren().size());
            for (Node c : n.getChildren()) {
                if (!NodeTree.this.hasPrintablesDeep(c)) continue;
                result.add(c);
            }
            return result.toArray();
        }
    }
}

