/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser2.model;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.request.Write;
import org.simantics.modeling.PropertyVariables;
import org.simantics.modeling.subscription.AddSubscriptionItems;
import org.simantics.modeling.utils.VariableReferences;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class SubscriptionNode
extends AbstractNode
implements IDeletable,
IDropTargetNode {
    public SubscriptionNode(Resource resource) {
        super(resource);
    }

    public void drop(Object data) {
        if (!(data instanceof ISelection)) {
            return;
        }
        List vars = ISelectionUtils.filterSelection((ISelection)((ISelection)data), PropertyVariables.class);
        if (!vars.isEmpty()) {
            try {
                List references = (List)Simantics.getSession().syncRequest(VariableReferences.toReferences((List)vars));
                this.addSubscriptions(references);
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        } else {
            List references = ISelectionUtils.filterSelection((ISelection)((ISelection)data), VariableReference.class);
            if (!references.isEmpty()) {
                this.addSubscriptions(references);
            }
        }
    }

    private void addSubscriptions(List<VariableReference> references) {
        Simantics.getSession().asyncRequest((Write)new AddSubscriptionItems(this.resource, references), e -> {
            if (e != null) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        });
    }
}

